/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing;

import java.util.Map;
import java.util.Set;
import org.apache.amoro.StateField;
import org.apache.amoro.api.OptimizingTask;
import org.apache.amoro.api.OptimizingTaskId;
import org.apache.amoro.api.OptimizingTaskResult;
import org.apache.amoro.exception.IllegalTaskStateException;
import org.apache.amoro.exception.TaskRuntimeException;
import org.apache.amoro.process.SimpleFuture;
import org.apache.amoro.process.StagedTaskDescriptor;
import org.apache.amoro.server.persistence.StatedPersistentBase;
import org.apache.amoro.server.persistence.mapper.OptimizingMapper;
import org.apache.amoro.server.resource.OptimizerThread;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableSet;

public class TaskRuntime<T extends StagedTaskDescriptor<?, ?, ?>>
extends StatedPersistentBase {
    private final SimpleFuture future = new SimpleFuture();
    private final TaskStatusMachine statusMachine = new TaskStatusMachine();
    private OptimizingTaskId taskId;
    private T taskDescriptor;
    @StateField
    private Status status = Status.PLANNED;
    @StateField
    private int runTimes = 0;
    @StateField
    private long startTime = 0L;
    @StateField
    private long endTime = 0L;
    @StateField
    private long costTime = 0L;
    @StateField
    private String token;
    @StateField
    private int threadId = -1;
    @StateField
    private String failReason;
    private static final Map<Status, Set<Status>> nextStatusMap = ImmutableMap.builder().put((Object)Status.PLANNED, (Object)ImmutableSet.of((Object)((Object)Status.SCHEDULED), (Object)((Object)Status.CANCELED))).put((Object)Status.SCHEDULED, (Object)ImmutableSet.of((Object)((Object)Status.PLANNED), (Object)((Object)Status.ACKED), (Object)((Object)Status.CANCELED))).put((Object)Status.ACKED, (Object)ImmutableSet.of((Object)((Object)Status.PLANNED), (Object)((Object)Status.SUCCESS), (Object)((Object)Status.FAILED), (Object)((Object)Status.CANCELED))).put((Object)Status.FAILED, (Object)ImmutableSet.of((Object)((Object)Status.PLANNED))).put((Object)Status.CANCELED, (Object)ImmutableSet.of()).put((Object)Status.SUCCESS, (Object)ImmutableSet.of()).build();

    public static long taskRunningQuotaTime(long calculatingStartTime, long calculatingEndTime, long taskStartTime, long taskCostTime) {
        if (taskStartTime == 0L) {
            return 0L;
        }
        calculatingStartTime = Math.max(taskStartTime, calculatingStartTime);
        calculatingEndTime = taskCostTime == 0L ? calculatingEndTime : taskCostTime + taskStartTime;
        long lastingTime = calculatingEndTime - calculatingStartTime;
        return Math.max(0L, lastingTime);
    }

    private TaskRuntime() {
    }

    public TaskRuntime(OptimizingTaskId taskId, T taskDescriptor) {
        this.taskId = taskId;
        this.taskDescriptor = taskDescriptor;
    }

    public T getTaskDescriptor() {
        return this.taskDescriptor;
    }

    public SimpleFuture getCompletedFuture() {
        return this.future;
    }

    public void complete(OptimizerThread thread, OptimizingTaskResult result) {
        this.invokeConsistency(() -> {
            this.validThread(thread);
            if (result.getErrorMessage() != null) {
                this.statusMachine.accept(Status.FAILED);
                this.failReason = result.getErrorMessage();
            } else {
                this.statusMachine.accept(Status.SUCCESS);
                this.taskDescriptor.setOutputBytes(result.getTaskOutput());
            }
            this.endTime = System.currentTimeMillis();
            this.costTime += this.endTime - this.startTime;
            ++this.runTimes;
            this.persistTaskRuntime();
            this.future.complete();
            this.token = null;
            this.threadId = -1;
        });
    }

    void reset() {
        this.invokeConsistency(() -> {
            if (this.status == Status.PLANNED) {
                return;
            }
            this.statusMachine.accept(Status.PLANNED);
            this.startTime = 0L;
            this.endTime = 0L;
            this.token = null;
            this.threadId = -1;
            this.failReason = null;
            this.taskDescriptor.reset();
            this.future.reset();
            this.persistTaskRuntime();
        });
    }

    public void schedule(OptimizerThread thread) {
        this.invokeConsistency(() -> {
            this.statusMachine.accept(Status.SCHEDULED);
            this.token = thread.getToken();
            this.threadId = thread.getThreadId();
            this.startTime = System.currentTimeMillis();
            this.persistTaskRuntime();
        });
    }

    public void ack(OptimizerThread thread) {
        this.invokeConsistency(() -> {
            this.validThread(thread);
            this.statusMachine.accept(Status.ACKED);
            this.persistTaskRuntime();
        });
    }

    void tryCanceling() {
        this.invokeConsistency(() -> {
            if (this.statusMachine.tryAccepting(Status.CANCELED)) {
                this.endTime = System.currentTimeMillis();
                if (this.startTime != 0L) {
                    this.costTime += this.endTime - this.startTime;
                }
                this.persistTaskRuntime();
                this.future.complete();
            }
        });
    }

    public boolean finished() {
        return this.status == Status.SUCCESS || this.status == Status.FAILED || this.status == Status.CANCELED;
    }

    public Map<String, String> getProperties() {
        return this.taskDescriptor.getProperties();
    }

    public long getProcessId() {
        return this.taskId.getProcessId();
    }

    public String getResourceDesc() {
        return this.token + ":" + this.threadId;
    }

    public String getToken() {
        return this.token;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public OptimizingTask extractProtocolTask() {
        return this.taskDescriptor.extractProtocolTask(this.taskId);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public OptimizingTaskId getTaskId() {
        return this.taskId;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getRunTimes() {
        return this.runTimes;
    }

    public int getRetry() {
        return this.runTimes - 1;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public long getCostTime() {
        return this.costTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getQuotaTime(long calculatingStartTime, long calculatingEndTime) {
        return TaskRuntime.taskRunningQuotaTime(calculatingStartTime, calculatingEndTime, this.startTime, this.costTime);
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getSummary() {
        return this.taskDescriptor.getSummary().toString();
    }

    public long getTableId() {
        return this.taskDescriptor.getTableId();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("runTimes", this.runTimes).add("startTime", this.startTime).add("endTime", this.endTime).add("costTime", this.costTime).add("resourceThread", (Object)this.getResourceDesc()).add("failReason", (Object)this.failReason).add("taskDescriptor", this.taskDescriptor).toString();
    }

    private void validThread(OptimizerThread thread) {
        if (this.token == null) {
            throw new TaskRuntimeException("Task has been reset or not yet scheduled, taskId:%s", new Object[]{this.taskId});
        }
        if (!thread.getToken().equals(this.getToken()) || thread.getThreadId() != this.threadId) {
            throw new TaskRuntimeException("The optimizer thread does not match, the thread in the task is OptimizerThread(token=%s, threadId=%s), and the thread in the request is OptimizerThread(token=%s, threadId=%s).", new Object[]{this.getToken(), this.threadId, thread.getToken(), thread.getThreadId()});
        }
    }

    private void persistTaskRuntime() {
        this.doAs(OptimizingMapper.class, mapper -> mapper.updateTaskRuntime(this));
    }

    public TaskQuota getCurrentQuota() {
        if (this.startTime == 0L || this.endTime == 0L) {
            throw new IllegalStateException("start time or end time is not correctly set");
        }
        return new TaskQuota(this);
    }

    public static class TaskQuota {
        private long processId;
        private int taskId;
        private int retryNum;
        private long startTime;
        private long endTime;
        private String failReason;
        private long tableId;

        public TaskQuota() {
        }

        public TaskQuota(TaskRuntime<?> task) {
            this.startTime = task.getStartTime();
            this.endTime = task.getEndTime();
            this.processId = task.getTaskId().getProcessId();
            this.taskId = task.getTaskId().getTaskId();
            this.tableId = task.getTableId();
            this.retryNum = task.getRetry();
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getProcessId() {
            return this.processId;
        }

        public int getTaskId() {
            return this.taskId;
        }

        public int getRetryNum() {
            return this.retryNum;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public String getFailReason() {
            return this.failReason;
        }

        public long getTableId() {
            return this.tableId;
        }

        public long getQuotaTime(long calculatingStartTime) {
            long lastingTime = this.endTime - Math.max(this.startTime, calculatingStartTime);
            return Math.max(0L, lastingTime);
        }

        public boolean checkExpired(long validTime) {
            return this.endTime <= validTime;
        }
    }

    public static enum Status {
        PLANNED,
        SCHEDULED,
        ACKED,
        FAILED,
        SUCCESS,
        CANCELED;

    }

    private class TaskStatusMachine {
        private TaskStatusMachine() {
        }

        public void accept(Status targetStatus) {
            if (!this.getNext().contains((Object)targetStatus)) {
                throw new IllegalTaskStateException(TaskRuntime.this.taskId, TaskRuntime.this.status.name(), targetStatus.name());
            }
            TaskRuntime.this.status = targetStatus;
        }

        private Set<Status> getNext() {
            return (Set)nextStatusMap.get((Object)TaskRuntime.this.status);
        }

        public synchronized boolean tryAccepting(Status targetStatus) {
            if (!this.getNext().contains((Object)targetStatus)) {
                return false;
            }
            TaskRuntime.this.status = targetStatus;
            return true;
        }
    }
}

