/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing.sorter;

import java.util.Comparator;
import java.util.Map;
import org.apache.amoro.server.optimizing.sorter.SorterFactory;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;

public class QuotaOccupySorter
implements SorterFactory {
    public static final String IDENTIFIER = "quota";

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Comparator<TableRuntime> createComparator() {
        return new Comparator<TableRuntime>(){
            final Map<TableRuntime, Double> tableWeightMap = Maps.newHashMap();

            @Override
            public int compare(TableRuntime one, TableRuntime another) {
                return Double.compare(this.tableWeightMap.computeIfAbsent(one, TableRuntime::calculateQuotaOccupy), this.tableWeightMap.computeIfAbsent(another, TableRuntime::calculateQuotaOccupy));
            }
        };
    }
}

