/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.amoro.config.ConfigHelpers;
import org.apache.amoro.config.DataExpirationConfig;
import org.apache.amoro.config.OptimizingConfig;
import org.apache.amoro.config.TableConfiguration;
import org.apache.amoro.config.TagConfiguration;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.TableProperties;
import org.apache.amoro.utils.CompatiblePropertyUtil;
import org.apache.amoro.utils.PropertyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfigurations {
    private static final Logger LOG = LoggerFactory.getLogger(TableConfigurations.class);
    public static final Set<Type.TypeID> DATA_EXPIRATION_FIELD_TYPES = Sets.newHashSet((Object[])new Type.TypeID[]{Type.TypeID.TIMESTAMP, Type.TypeID.STRING, Type.TypeID.LONG});

    public static TableConfiguration parseTableConfig(Map<String, String> properties) {
        boolean gcEnabled = CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"gc.enabled", (boolean)true);
        return new TableConfiguration().setExpireSnapshotEnabled(gcEnabled && CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"table-expire.enabled", (boolean)true)).setSnapshotTTLMinutes(ConfigHelpers.TimeUtils.parseDuration((String)CompatiblePropertyUtil.propertyAsString(properties, (String)"snapshot.keep.duration", (String)"720min"), (ChronoUnit)ChronoUnit.MINUTES).getSeconds() / 60L).setSnapshotMinCount(CompatiblePropertyUtil.propertyAsInt(properties, (String)"snapshot.keep.min-count", (int)1)).setChangeDataTTLMinutes(CompatiblePropertyUtil.propertyAsLong(properties, (String)"change.data.ttl.minutes", (long)10080L)).setCleanOrphanEnabled(gcEnabled && CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"clean-orphan-file.enabled", (boolean)false)).setOrphanExistingMinutes(CompatiblePropertyUtil.propertyAsLong(properties, (String)"clean-orphan-file.min-existing-time-minutes", (long)2880L)).setDeleteDanglingDeleteFilesEnabled(gcEnabled && CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"clean-dangling-delete-files.enabled", (boolean)true)).setOptimizingConfig(TableConfigurations.parseOptimizingConfig(properties)).setExpiringDataConfig(TableConfigurations.parseDataExpirationConfig(properties)).setTagConfiguration(TableConfigurations.parseTagConfiguration(properties));
    }

    @VisibleForTesting
    public static DataExpirationConfig parseDataExpirationConfig(Map<String, String> properties) {
        boolean gcEnabled = CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"gc.enabled", (boolean)true);
        DataExpirationConfig config = new DataExpirationConfig().setEnabled(gcEnabled && CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"data-expire.enabled", (boolean)false)).setExpirationLevel(DataExpirationConfig.ExpireLevel.fromString((String)CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.level", (String)"partition"))).setExpirationField(CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.field", null)).setDateTimePattern(CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.datetime-string-pattern", (String)"yyyy-MM-dd")).setNumberDateFormat(CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.datetime-number-format", (String)"TIMESTAMP_MS")).setBaseOnRule(TableConfigurations.parseDataExpirationBaseOnRule(CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.base-on-rule", (String)"LAST_COMMIT_TIME")));
        String retention = CompatiblePropertyUtil.propertyAsString(properties, (String)"data-expire.retention-time", null);
        if (StringUtils.isNotBlank((CharSequence)retention)) {
            config.setRetentionTime(ConfigHelpers.TimeUtils.parseDuration((String)retention).toMillis());
        }
        return config;
    }

    private static DataExpirationConfig.BaseOnRule parseDataExpirationBaseOnRule(String since) {
        Preconditions.checkArgument((null != since ? 1 : 0) != 0, (Object)"data-expire.base-on-rule is invalid: null");
        try {
            return DataExpirationConfig.BaseOnRule.valueOf((String)since.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unable to expire data since: %s", since), e);
        }
    }

    public static boolean isValidDataExpirationField(DataExpirationConfig config, Types.NestedField field, String name) {
        return config.isEnabled() && config.getRetentionTime() > 0L && TableConfigurations.validateExpirationField(field, name, config.getExpirationField());
    }

    private static boolean validateExpirationField(Types.NestedField field, String name, String expirationField) {
        if (StringUtils.isBlank((CharSequence)expirationField) || null == field) {
            LOG.warn(String.format("Field(%s) used to determine data expiration is illegal for table(%s)", expirationField, name));
            return false;
        }
        Type.TypeID typeID = field.type().typeId();
        if (!DATA_EXPIRATION_FIELD_TYPES.contains(typeID)) {
            LOG.warn(String.format("Table(%s) field(%s) type(%s) is not supported for data expiration, please use the following types: %s", name, expirationField, typeID.name(), StringUtils.join(DATA_EXPIRATION_FIELD_TYPES, (String)", ")));
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public static OptimizingConfig parseOptimizingConfig(Map<String, String> properties) {
        return new OptimizingConfig().setEnabled(CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"self-optimizing.enabled", (boolean)true)).setMaxExecuteRetryCount(CompatiblePropertyUtil.propertyAsInt(properties, (String)"self-optimizing.execute.num-retries", (int)5)).setOptimizerGroup(CompatiblePropertyUtil.propertyAsString(properties, (String)"self-optimizing.group", (String)"default")).setFragmentRatio(CompatiblePropertyUtil.propertyAsInt(properties, (String)"self-optimizing.fragment-ratio", (int)8)).setMinTargetSizeRatio(CompatiblePropertyUtil.propertyAsDouble(properties, (String)"self-optimizing.min-target-size-ratio", (double)0.75)).setMaxFileCount(CompatiblePropertyUtil.propertyAsInt(properties, (String)"self-optimizing.max-file-count", (int)10000)).setOpenFileCost(CompatiblePropertyUtil.propertyAsLong(properties, (String)"read.split.open-file-cost", (long)0x400000L)).setTargetSize(CompatiblePropertyUtil.propertyAsLong(properties, (String)"self-optimizing.target-size", (long)0x8000000L)).setMaxTaskSize(CompatiblePropertyUtil.propertyAsLong(properties, (String)"self-optimizing.max-task-size-bytes", (long)0x8000000L)).setTargetQuota(CompatiblePropertyUtil.propertyAsDouble(properties, (String)"self-optimizing.quota", (double)0.1)).setMinorLeastFileCount(CompatiblePropertyUtil.propertyAsInt(properties, (String)"self-optimizing.minor.trigger.file-count", (int)12)).setMinorLeastInterval(CompatiblePropertyUtil.propertyAsInt(properties, (String)"self-optimizing.minor.trigger.interval", (int)3600000)).setMajorDuplicateRatio(CompatiblePropertyUtil.propertyAsDouble(properties, (String)"self-optimizing.major.trigger.duplicate-ratio", (double)0.1)).setFullTriggerInterval(CompatiblePropertyUtil.propertyAsInt(properties, (String)"self-optimizing.full.trigger.interval", (int)-1)).setFullRewriteAllFiles(CompatiblePropertyUtil.propertyAsBoolean(properties, (String)"self-optimizing.full.rewrite-all-files", (boolean)true)).setFilter(CompatiblePropertyUtil.propertyAsString(properties, (String)"self-optimizing.filter", (String)TableProperties.SELF_OPTIMIZING_FILTER_DEFAULT)).setBaseHashBucket(CompatiblePropertyUtil.propertyAsInt(properties, (String)"base.file-index.hash-bucket", (int)4)).setBaseRefreshInterval(PropertyUtil.propertyAsLong(properties, (String)"base.refresh-interval", (long)-1L)).setHiveRefreshInterval(PropertyUtil.propertyAsLong(properties, (String)"base.hive.refresh-interval", (long)-1L)).setMinPlanInterval(PropertyUtil.propertyAsLong(properties, (String)"self-optimizing.min-plan-interval", (long)60000L));
    }

    @VisibleForTesting
    public static TagConfiguration parseTagConfiguration(Map<String, String> tableProperties) {
        String defaultFormat;
        TagConfiguration tagConfig = new TagConfiguration();
        tagConfig.setAutoCreateTag(CompatiblePropertyUtil.propertyAsBoolean(tableProperties, (String)"tag.auto-create.enabled", (boolean)false));
        tagConfig.setTriggerPeriod(TagConfiguration.Period.valueOf((String)CompatiblePropertyUtil.propertyAsString(tableProperties, (String)"tag.auto-create.trigger.period", (String)"daily").toUpperCase(Locale.ROOT)));
        switch (tagConfig.getTriggerPeriod()) {
            case DAILY: {
                defaultFormat = "'tag-'yyyyMMdd";
                break;
            }
            case HOURLY: {
                defaultFormat = "'tag-'yyyyMMddHH";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported trigger period: " + tagConfig.getTriggerPeriod());
            }
        }
        tagConfig.setTagFormat(CompatiblePropertyUtil.propertyAsString(tableProperties, (String)"tag.auto-create.tag-format", (String)defaultFormat));
        tagConfig.setTriggerOffsetMinutes(CompatiblePropertyUtil.propertyAsInt(tableProperties, (String)"tag.auto-create.trigger.offset.minutes", (int)0));
        tagConfig.setMaxDelayMinutes(CompatiblePropertyUtil.propertyAsInt(tableProperties, (String)"tag.auto-create.trigger.max-delay.minutes", (int)60));
        tagConfig.setTagMaxAgeMs(CompatiblePropertyUtil.propertyAsLong(tableProperties, (String)"tag.auto-create.max-age-ms", (long)-1L));
        return tagConfig;
    }
}

