/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import org.apache.amoro.AmoroTable;
import org.apache.amoro.config.TableConfiguration;
import org.apache.amoro.optimizing.plan.AbstractOptimizingEvaluator;
import org.apache.amoro.process.ProcessStatus;
import org.apache.amoro.server.optimizing.OptimizingProcess;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.table.executor.BaseTableExecutor;
import org.apache.amoro.server.utils.IcebergTableUtil;
import org.apache.amoro.table.MixedTable;

public class TableRuntimeRefreshExecutor
extends BaseTableExecutor {
    private final long interval;
    private final int maxPendingPartitions;

    public TableRuntimeRefreshExecutor(TableService tableService, int poolSize, long interval, int maxPendingPartitions) {
        super(tableService, poolSize);
        this.interval = interval;
        this.maxPendingPartitions = maxPendingPartitions;
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return true;
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return Math.min((long)tableRuntime.getOptimizingConfig().getMinorLeastInterval() * 4L / 5L, this.interval);
    }

    private void tryEvaluatingPendingInput(TableRuntime tableRuntime, MixedTable table) {
        if (tableRuntime.isOptimizingEnabled() && !tableRuntime.getOptimizingStatus().isProcessing()) {
            AbstractOptimizingEvaluator evaluator = IcebergTableUtil.createOptimizingEvaluator(tableRuntime, table, this.maxPendingPartitions);
            if (evaluator.isNecessary()) {
                AbstractOptimizingEvaluator.PendingInput pendingInput = evaluator.getOptimizingPendingInput();
                this.logger.debug("{} optimizing is necessary and get pending input {}", (Object)tableRuntime.getTableIdentifier(), (Object)pendingInput);
                tableRuntime.setPendingInput(pendingInput);
            } else {
                tableRuntime.optimizingNotNecessary();
            }
            tableRuntime.setTableSummary(evaluator.getPendingInput());
        }
    }

    @Override
    public void handleConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
        OptimizingProcess optimizingProcess;
        if (originalConfig.getOptimizingConfig().isEnabled() && !tableRuntime.getTableConfiguration().getOptimizingConfig().isEnabled() && (optimizingProcess = tableRuntime.getOptimizingProcess()) != null && optimizingProcess.getStatus() == ProcessStatus.RUNNING) {
            optimizingProcess.close();
        }
    }

    @Override
    public void execute(TableRuntime tableRuntime) {
        try {
            long lastOptimizedSnapshotId = tableRuntime.getLastOptimizedSnapshotId();
            long lastOptimizedChangeSnapshotId = tableRuntime.getLastOptimizedChangeSnapshotId();
            AmoroTable<?> table = this.loadTable(tableRuntime);
            tableRuntime.refresh(table);
            MixedTable mixedTable = (MixedTable)table.originalTable();
            if (mixedTable.isKeyedTable() && (lastOptimizedSnapshotId != tableRuntime.getCurrentSnapshotId() || lastOptimizedChangeSnapshotId != tableRuntime.getCurrentChangeSnapshotId()) || mixedTable.isUnkeyedTable() && lastOptimizedSnapshotId != tableRuntime.getCurrentSnapshotId()) {
                this.tryEvaluatingPendingInput(tableRuntime, mixedTable);
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Refreshing table {} failed.", (Object)tableRuntime.getTableIdentifier(), (Object)throwable);
        }
    }
}

