/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.terminal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.amoro.config.ConfigOption;
import org.apache.amoro.config.ConfigOptions;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.server.terminal.TerminalSession;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.TableMetaStore;

public interface TerminalSessionFactory {
    public static final ConfigOption<Integer> FETCH_SIZE = ConfigOptions.key((String)"fetch-size").intType().defaultValue((Object)1000);

    public void initialize(Configurations var1);

    public TerminalSession create(TableMetaStore var1, Configurations var2);

    public static class SessionConfigOptions {
        public static ConfigOption<Integer> FETCH_SIZE = ConfigOptions.key((String)"session.fetch-size").intType().defaultValue((Object)1000);
        public static ConfigOption<List<String>> CATALOGS = ConfigOptions.key((String)"session.catalogs").stringType().asList().noDefaultValue();
        public static ConfigOption<String> CATALOG_URL_BASE = ConfigOptions.key((String)"catalog-url-base").stringType().noDefaultValue();
        public static ConfigOption<Boolean> USING_SESSION_CATALOG_FOR_HIVE = ConfigOptions.key((String)"using-session-catalog-for-hive").booleanType().defaultValue((Object)false);

        public static ConfigOption<String> catalogConnector(String catalog) {
            return ConfigOptions.key((String)("session.catalog." + catalog + ".connector")).stringType().noDefaultValue();
        }

        public static ConfigOption<String> catalogType(String catalog) {
            return ConfigOptions.key((String)("session.catalog." + catalog + ".type")).stringType().noDefaultValue();
        }

        public static ConfigOption<String> catalogProperty(String catalog, String propertyKey) {
            return ConfigOptions.key((String)("catalog." + catalog + "." + propertyKey)).stringType().noDefaultValue();
        }

        public static Map<String, String> getCatalogProperties(Configurations configuration, String catalog) {
            String prefix = "catalog." + catalog + ".";
            HashMap properties = Maps.newHashMap();
            for (String key : configuration.keySet()) {
                if (!key.startsWith(prefix)) continue;
                ConfigOption confOption = ConfigOptions.key((String)key).stringType().noDefaultValue();
                properties.put(key.substring(prefix.length()), configuration.getString(confOption));
            }
            return properties;
        }
    }
}

