/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.config;

import java.util.Locale;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Objects;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DataExpirationConfig {
    private boolean enabled;
    private String expirationField;
    private ExpireLevel expirationLevel;
    private long retentionTime;
    private String dateTimePattern;
    private String numberDateFormat;
    private BaseOnRule baseOnRule;

    public boolean isEnabled() {
        return this.enabled;
    }

    public DataExpirationConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getExpirationField() {
        return this.expirationField;
    }

    public DataExpirationConfig setExpirationField(String expirationField) {
        this.expirationField = expirationField;
        return this;
    }

    public ExpireLevel getExpirationLevel() {
        return this.expirationLevel;
    }

    public DataExpirationConfig setExpirationLevel(ExpireLevel expirationLevel) {
        this.expirationLevel = expirationLevel;
        return this;
    }

    public long getRetentionTime() {
        return this.retentionTime;
    }

    public DataExpirationConfig setRetentionTime(long retentionTime) {
        this.retentionTime = retentionTime;
        return this;
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    public DataExpirationConfig setDateTimePattern(String dateTimePattern) {
        this.dateTimePattern = dateTimePattern;
        return this;
    }

    public String getNumberDateFormat() {
        return this.numberDateFormat;
    }

    public DataExpirationConfig setNumberDateFormat(String numberDateFormat) {
        this.numberDateFormat = numberDateFormat;
        return this;
    }

    public BaseOnRule getBaseOnRule() {
        return this.baseOnRule;
    }

    public DataExpirationConfig setBaseOnRule(BaseOnRule baseOnRule) {
        this.baseOnRule = baseOnRule;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataExpirationConfig)) {
            return false;
        }
        DataExpirationConfig config = (DataExpirationConfig)o;
        return this.enabled == config.enabled && this.retentionTime == config.retentionTime && Objects.equal((Object)this.expirationField, (Object)config.expirationField) && this.expirationLevel == config.expirationLevel && Objects.equal((Object)this.dateTimePattern, (Object)config.dateTimePattern) && Objects.equal((Object)this.numberDateFormat, (Object)config.numberDateFormat) && this.baseOnRule == config.baseOnRule;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enabled, this.expirationField, this.expirationLevel, this.retentionTime, this.dateTimePattern, this.numberDateFormat, this.baseOnRule});
    }

    @VisibleForTesting
    public static enum BaseOnRule {
        LAST_COMMIT_TIME,
        CURRENT_TIME;

    }

    @VisibleForTesting
    public static enum ExpireLevel {
        PARTITION,
        FILE;


        public static ExpireLevel fromString(String level) {
            Preconditions.checkArgument((null != level ? 1 : 0) != 0, (Object)"Invalid level type: null");
            try {
                return ExpireLevel.valueOf(level.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid level type: %s", level), e);
            }
        }
    }
}

