/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.amoro.table.KeyedTable;
import org.apache.iceberg.PendingUpdate;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateStatistics;

public abstract class PartitionTransactionOperation
implements PendingUpdate<List<StatisticsFile>> {
    KeyedTable keyedTable;
    private Transaction tx;
    private boolean skipEmptyCommit = false;
    protected final Map<String, String> properties;

    public PartitionTransactionOperation(KeyedTable keyedTable) {
        this.keyedTable = keyedTable;
        this.properties = new HashMap<String, String>();
    }

    public PartitionTransactionOperation set(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    protected abstract boolean isEmptyCommit();

    protected abstract List<StatisticsFile> apply(Transaction var1);

    public List<StatisticsFile> apply() {
        return this.apply(this.tx);
    }

    public PartitionTransactionOperation skipEmptyCommit() {
        this.skipEmptyCommit = true;
        return this;
    }

    public void commit() {
        if (this.skipEmptyCommit && this.isEmptyCommit()) {
            return;
        }
        this.tx = this.keyedTable.baseTable().newTransaction();
        Object statisticsFiles = this.apply();
        if (statisticsFiles != null && !statisticsFiles.isEmpty()) {
            UpdateStatistics updateStatistics = this.tx.updateStatistics();
            statisticsFiles.forEach(s -> updateStatistics.setStatistics(s.snapshotId(), s));
            updateStatistics.commit();
        }
        this.tx.commitTransaction();
    }
}

