/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.table.blocker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.AmsClient;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.api.OperationConflictException;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.blocker.Blocker;
import org.apache.amoro.table.blocker.RenewableBlocker;
import org.apache.amoro.table.blocker.TableBlockerManager;
import org.apache.iceberg.util.PropertyUtil;

public class BasicTableBlockerManager
implements TableBlockerManager {
    private final TableIdentifier tableIdentifier;
    private final AmsClient client;

    public BasicTableBlockerManager(TableIdentifier tableIdentifier, AmsClient client) {
        this.tableIdentifier = tableIdentifier;
        this.client = client;
    }

    public static TableBlockerManager build(TableIdentifier tableIdentifier, AmsClient amsClient) {
        return new BasicTableBlockerManager(tableIdentifier, amsClient);
    }

    @Override
    public Blocker block(List<BlockableOperation> operations, Map<String, String> properties) throws OperationConflictException {
        try {
            Preconditions.checkNotNull(properties, (Object)"properties should not be null");
            return this.buildBlocker(this.client.block(this.tableIdentifier.buildTableIdentifier(), operations, properties), true);
        }
        catch (OperationConflictException e) {
            throw e;
        }
        catch (TException e) {
            throw new IllegalStateException("failed to block table " + this.tableIdentifier + " with " + operations, e);
        }
    }

    @Override
    public void release(Blocker blocker) {
        try {
            this.client.releaseBlocker(this.tableIdentifier.buildTableIdentifier(), blocker.blockerId());
        }
        catch (TException e) {
            throw new IllegalStateException("failed to release " + this.tableIdentifier + "'s blocker " + blocker.blockerId(), e);
        }
        finally {
            if (blocker instanceof RenewableBlocker) {
                ((RenewableBlocker)blocker).cancelRenew();
            }
        }
    }

    @Override
    public List<Blocker> getBlockers() {
        try {
            return this.client.getBlockers(this.tableIdentifier.buildTableIdentifier()).stream().map(this::buildBlocker).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new IllegalStateException("failed to get blockers of " + this.tableIdentifier, e);
        }
    }

    @Override
    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    private Blocker buildBlocker(org.apache.amoro.api.Blocker blocker) {
        return this.buildBlocker(blocker, false);
    }

    private Blocker buildBlocker(org.apache.amoro.api.Blocker blocker, boolean needInit) {
        if (blocker.getProperties() != null && blocker.getProperties().get("expiration.time") != null && blocker.getProperties().get("blocker.timeout") != null) {
            HashMap properties = Maps.newHashMap((Map)blocker.getProperties());
            long createTime = PropertyUtil.propertyAsLong((Map)properties, (String)"create.time", (long)0L);
            long expirationTime = PropertyUtil.propertyAsLong((Map)properties, (String)"expiration.time", (long)0L);
            long blockerTimeout = PropertyUtil.propertyAsLong((Map)properties, (String)"blocker.timeout", (long)0L);
            properties.remove("create.time");
            properties.remove("expiration.time");
            properties.remove("blocker.timeout");
            RenewableBlocker renewableBlocker = new RenewableBlocker(blocker.getBlockerId(), blocker.getOperations(), createTime, expirationTime, blockerTimeout, properties, this.tableIdentifier, this.client);
            if (needInit) {
                renewableBlocker.renewAsync();
            }
            return renewableBlocker;
        }
        throw new IllegalArgumentException("illegal blocker " + blocker);
    }
}

