/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.io.reader;

import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.hive.io.reader.AdaptHiveMixedDeleteFilter;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.reader.AbstractKeyedDataReader;
import org.apache.amoro.io.reader.MixedDeleteFilter;
import org.apache.amoro.scan.KeyedTableScanTask;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.parquet.AdaptHiveParquet;
import org.apache.iceberg.types.Type;

public abstract class AbstractAdaptHiveKeyedDataReader<T>
extends AbstractKeyedDataReader<T> {
    public AbstractAdaptHiveKeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, Set<DataTreeNode> sourceNodes, boolean reuseContainer, StructLikeCollections structLikeCollections) {
        super(fileIO, tableSchema, projectedSchema, primaryKeySpec, nameMapping, caseSensitive, convertConstant, sourceNodes, reuseContainer, structLikeCollections);
    }

    public AbstractAdaptHiveKeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, boolean reuseContainer) {
        super(fileIO, tableSchema, projectedSchema, primaryKeySpec, nameMapping, caseSensitive, convertConstant, reuseContainer);
    }

    public AbstractAdaptHiveKeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, Set<DataTreeNode> sourceNodes, boolean reuseContainer) {
        super(fileIO, tableSchema, projectedSchema, primaryKeySpec, nameMapping, caseSensitive, convertConstant, sourceNodes, reuseContainer);
    }

    protected MixedDeleteFilter<T> createMixedDeleteFilter(KeyedTableScanTask keyedTableScanTask, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, Set<DataTreeNode> sourceNodes, StructLikeCollections structLikeCollections) {
        return new AdaptHiveGenericMixedDeleteFilter(keyedTableScanTask, tableSchema, projectedSchema, primaryKeySpec, sourceNodes, structLikeCollections);
    }

    protected CloseableIterable<T> newParquetIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant) {
        AdaptHiveParquet.ReadBuilder builder = AdaptHiveParquet.read(this.fileIO.newInputFile(((DataFile)task.file()).path().toString())).split(task.start(), task.length()).project(schema).createReaderFunc(this.getParquetReaderFunction(schema, idToConstant)).filter(task.residual()).caseSensitive(this.caseSensitive);
        if (this.reuseContainer) {
            builder.reuseContainers();
        }
        if (this.nameMapping != null) {
            builder.withNameMapping(NameMappingParser.fromJson((String)this.nameMapping));
        }
        return builder.build();
    }

    private class AdaptHiveGenericMixedDeleteFilter
    extends AdaptHiveMixedDeleteFilter<T> {
        protected Function<T, StructLike> asStructLike;

        protected AdaptHiveGenericMixedDeleteFilter(KeyedTableScanTask keyedTableScanTask, Schema tableSchema, Schema requestedSchema, PrimaryKeySpec primaryKeySpec) {
            super(keyedTableScanTask, tableSchema, requestedSchema, primaryKeySpec);
            this.asStructLike = (Function)AbstractAdaptHiveKeyedDataReader.this.toStructLikeFunction().apply(this.requiredSchema());
        }

        protected AdaptHiveGenericMixedDeleteFilter(KeyedTableScanTask keyedTableScanTask, Schema tableSchema, Schema requestedSchema, PrimaryKeySpec primaryKeySpec, Set<DataTreeNode> sourceNodes, StructLikeCollections structLikeCollections) {
            super(keyedTableScanTask, tableSchema, requestedSchema, primaryKeySpec, sourceNodes, structLikeCollections);
            this.asStructLike = (Function)AbstractAdaptHiveKeyedDataReader.this.toStructLikeFunction().apply(this.requiredSchema());
        }

        protected AdaptHiveGenericMixedDeleteFilter(KeyedTableScanTask keyedTableScanTask, Schema tableSchema, Schema requestedSchema, PrimaryKeySpec primaryKeySpec, Set<DataTreeNode> sourceNodes) {
            super(keyedTableScanTask, tableSchema, requestedSchema, primaryKeySpec, sourceNodes);
            this.asStructLike = (Function)AbstractAdaptHiveKeyedDataReader.this.toStructLikeFunction().apply(this.requiredSchema());
        }

        protected StructLike asStructLike(T record) {
            return this.asStructLike.apply(record);
        }

        protected InputFile getInputFile(String location) {
            return AbstractAdaptHiveKeyedDataReader.this.fileIO.newInputFile(location);
        }

        protected AuthenticatedFileIO getFileIO() {
            return AbstractAdaptHiveKeyedDataReader.this.fileIO;
        }
    }
}

