/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.InterestingProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.OperatorDescriptorSingle;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.NamedChannel;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.util.NoOpUnaryUdfOp;
import org.apache.flink.runtime.io.network.DataExchangeMode;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.shaded.guava31.com.google.common.collect.Sets;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public abstract class SingleInputNode
extends OptimizerNode {
    protected final FieldSet keys;
    protected DagConnection inConn;

    protected SingleInputNode(SingleInputOperator<?, ?, ?> programOperator) {
        super((Operator<?>)programOperator);
        int[] k = programOperator.getKeyColumns(0);
        this.keys = k == null || k.length == 0 ? null : new FieldSet(k);
    }

    protected SingleInputNode(FieldSet keys) {
        super((Operator<?>)NoOpUnaryUdfOp.INSTANCE);
        this.keys = keys;
    }

    protected SingleInputNode() {
        super((Operator<?>)NoOpUnaryUdfOp.INSTANCE);
        this.keys = null;
    }

    protected SingleInputNode(SingleInputNode toCopy) {
        super(toCopy);
        this.keys = toCopy.keys;
    }

    public SingleInputOperator<?, ?, ?> getOperator() {
        return (SingleInputOperator)super.getOperator();
    }

    public DagConnection getIncomingConnection() {
        return this.inConn;
    }

    public void setIncomingConnection(DagConnection inConn) {
        this.inConn = inConn;
    }

    public OptimizerNode getPredecessorNode() {
        if (this.inConn != null) {
            return this.inConn.getSource();
        }
        return null;
    }

    @Override
    public List<DagConnection> getIncomingConnections() {
        return Collections.singletonList(this.inConn);
    }

    @Override
    public SemanticProperties getSemanticProperties() {
        return this.getOperator().getSemanticProperties();
    }

    protected SemanticProperties getSemanticPropertiesForLocalPropertyFiltering() {
        return this.getSemanticProperties();
    }

    protected SemanticProperties getSemanticPropertiesForGlobalPropertyFiltering() {
        return this.getSemanticProperties();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setInput(Map<Operator<?>, OptimizerNode> contractToNode, ExecutionMode defaultExchangeMode) throws CompilerException {
        ShipStrategyType preSet;
        Configuration conf = this.getOperator().getParameters();
        String shipStrategy = conf.getString("INPUT_SHIP_STRATEGY", null);
        if (shipStrategy != null) {
            if (shipStrategy.equalsIgnoreCase("SHIP_REPARTITION_HASH")) {
                preSet = ShipStrategyType.PARTITION_HASH;
            } else if (shipStrategy.equalsIgnoreCase("SHIP_REPARTITION_RANGE")) {
                preSet = ShipStrategyType.PARTITION_RANGE;
            } else if (shipStrategy.equalsIgnoreCase("SHIP_FORWARD")) {
                preSet = ShipStrategyType.FORWARD;
            } else {
                if (!shipStrategy.equalsIgnoreCase("SHIP_REPARTITION")) throw new CompilerException("Unrecognized ship strategy hint: " + shipStrategy);
                preSet = ShipStrategyType.PARTITION_RANDOM;
            }
        } else {
            preSet = null;
        }
        Operator children = this.getOperator().getInput();
        if (children == null) {
            throw new CompilerException("Error: Node for '" + this.getOperator().getName() + "' has no input.");
        }
        OptimizerNode pred = contractToNode.get(children);
        DagConnection conn = new DagConnection(pred, this, defaultExchangeMode);
        if (preSet != null) {
            conn.setShipStrategy(preSet);
        }
        this.setIncomingConnection(conn);
        pred.addOutgoingConnection(conn);
    }

    protected abstract List<OperatorDescriptorSingle> getPossibleProperties();

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
        InterestingProperties props = this.getInterestingProperties().filterByCodeAnnotations(this, 0);
        for (OperatorDescriptorSingle dps : this.getPossibleProperties()) {
            for (RequestedGlobalProperties gp : dps.getPossibleGlobalProperties()) {
                if (gp.getPartitioning().isPartitionedOnKey()) {
                    for (RequestedGlobalProperties contained : props.getGlobalProperties()) {
                        if (contained.getPartitioning() != gp.getPartitioning() || !gp.getPartitionedFields().isValidSubset(contained.getPartitionedFields())) continue;
                        props.getGlobalProperties().remove(contained);
                        break;
                    }
                }
                props.addGlobalProperties(gp);
            }
            for (RequestedLocalProperties lp : dps.getPossibleLocalProperties()) {
                props.addLocalProperties(lp);
            }
        }
        this.inConn.setInterestingProperties(props);
        for (DagConnection conn : this.getBroadcastConnections()) {
            conn.setInterestingProperties(new InterestingProperties());
        }
    }

    @Override
    public List<PlanNode> getAlternativePlans(CostEstimator estimator) {
        if (this.cachedPlans != null) {
            return this.cachedPlans;
        }
        boolean childrenSkippedDueToReplicatedInput = false;
        List<PlanNode> subPlans = this.getPredecessorNode().getAlternativePlans(estimator);
        Set<RequestedGlobalProperties> intGlobal = this.inConn.getInterestingProperties().getGlobalProperties();
        ArrayList<Set<? extends NamedChannel>> broadcastPlanChannels = new ArrayList<Set<? extends NamedChannel>>();
        List<DagConnection> broadcastConnections = this.getBroadcastConnections();
        List<String> broadcastConnectionNames = this.getBroadcastConnectionNames();
        for (int i = 0; i < broadcastConnections.size(); ++i) {
            DagConnection broadcastConnection = broadcastConnections.get(i);
            String broadcastConnectionName = broadcastConnectionNames.get(i);
            List<PlanNode> broadcastPlanCandidates = broadcastConnection.getSource().getAlternativePlans(estimator);
            HashSet<NamedChannel> broadcastChannels = new HashSet<NamedChannel>(broadcastPlanCandidates.size());
            for (PlanNode plan : broadcastPlanCandidates) {
                NamedChannel c = new NamedChannel(broadcastConnectionName, plan);
                DataExchangeMode exMode = DataExchangeMode.select((ExecutionMode)broadcastConnection.getDataExchangeMode(), (ShipStrategyType)ShipStrategyType.BROADCAST, (boolean)broadcastConnection.isBreakingPipeline());
                c.setShipStrategy(ShipStrategyType.BROADCAST, exMode);
                broadcastChannels.add(c);
            }
            broadcastPlanChannels.add(broadcastChannels);
        }
        HashSet<RequestedGlobalProperties> pairs = new HashSet<RequestedGlobalProperties>();
        for (OperatorDescriptorSingle ods : this.getPossibleProperties()) {
            pairs.addAll(ods.getPossibleGlobalProperties());
        }
        RequestedGlobalProperties[] allValidGlobals = pairs.toArray(new RequestedGlobalProperties[pairs.size()]);
        ArrayList<PlanNode> outputPlans = new ArrayList<PlanNode>();
        ExecutionMode executionMode = this.inConn.getDataExchangeMode();
        int parallelism = this.getParallelism();
        int inParallelism = this.getPredecessorNode().getParallelism();
        boolean parallelismChange = inParallelism != parallelism;
        boolean breaksPipeline = this.inConn.isBreakingPipeline();
        block3: for (PlanNode child : subPlans) {
            if (child.getGlobalProperties().isFullyReplicated()) {
                if (parallelismChange) {
                    childrenSkippedDueToReplicatedInput = true;
                    continue;
                }
                this.inConn.setShipStrategy(ShipStrategyType.FORWARD);
            }
            if (this.inConn.getShipStrategy() == null) {
                block4: for (RequestedGlobalProperties igps : intGlobal) {
                    Channel c = new Channel(child, this.inConn.getMaterializationMode());
                    igps.parameterizeChannel(c, parallelismChange, executionMode, breaksPipeline);
                    if (parallelismChange && !c.getShipStrategy().isNetworkStrategy()) {
                        c.getGlobalProperties().reset();
                    }
                    for (RequestedGlobalProperties rgps : allValidGlobals) {
                        if (!rgps.isMetBy(c.getGlobalProperties())) continue;
                        c.setRequiredGlobalProps(rgps);
                        this.addLocalCandidates(c, broadcastPlanChannels, igps, outputPlans, estimator);
                        continue block4;
                    }
                }
                continue;
            }
            Channel c = new Channel(child, this.inConn.getMaterializationMode());
            ShipStrategyType shipStrategy = this.inConn.getShipStrategy();
            DataExchangeMode exMode = DataExchangeMode.select((ExecutionMode)executionMode, (ShipStrategyType)shipStrategy, (boolean)breaksPipeline);
            if (this.keys != null) {
                c.setShipStrategy(shipStrategy, this.keys.toFieldList(), exMode);
            } else {
                c.setShipStrategy(shipStrategy, exMode);
            }
            if (parallelismChange) {
                c.adjustGlobalPropertiesForFullParallelismChange();
            }
            for (RequestedGlobalProperties rgps : allValidGlobals) {
                if (!rgps.isMetBy(c.getGlobalProperties())) continue;
                this.addLocalCandidates(c, broadcastPlanChannels, rgps, outputPlans, estimator);
                continue block3;
            }
        }
        if (outputPlans.isEmpty()) {
            if (childrenSkippedDueToReplicatedInput) {
                throw new CompilerException("No plan meeting the requirements could be created @ " + this + ". Most likely reason: Invalid use of replicated input.");
            }
            throw new CompilerException("No plan meeting the requirements could be created @ " + this + ". Most likely reason: Too restrictive plan hints.");
        }
        for (PlanNode node : outputPlans) {
            estimator.costOperator(node);
        }
        this.prunePlanAlternatives(outputPlans);
        outputPlans.trimToSize();
        this.cachedPlans = outputPlans;
        return outputPlans;
    }

    protected void addLocalCandidates(Channel template, List<Set<? extends NamedChannel>> broadcastPlanChannels, RequestedGlobalProperties rgps, List<PlanNode> target, CostEstimator estimator) {
        block0: for (RequestedLocalProperties ilp : this.inConn.getInterestingProperties().getLocalProperties()) {
            Channel in = template.clone();
            ilp.parameterizeChannel(in);
            for (OperatorDescriptorSingle dps : this.getPossibleProperties()) {
                for (RequestedLocalProperties ilps : dps.getPossibleLocalProperties()) {
                    if (!ilps.isMetBy(in.getLocalProperties())) continue;
                    in.setRequiredLocalProps(ilps);
                    this.instantiateCandidate(dps, in, broadcastPlanChannels, target, estimator, rgps, ilp);
                    continue block0;
                }
            }
        }
    }

    protected void instantiateCandidate(OperatorDescriptorSingle dps, Channel in, List<Set<? extends NamedChannel>> broadcastPlanChannels, List<PlanNode> target, CostEstimator estimator, RequestedGlobalProperties globPropsReq, RequestedLocalProperties locPropsReq) {
        PlanNode inputSource = in.getSource();
        for (List broadcastChannelsCombination : Sets.cartesianProduct(broadcastPlanChannels)) {
            boolean validCombination = true;
            boolean requiresPipelinebreaker = false;
            block1: for (int i = 0; i < broadcastChannelsCombination.size(); ++i) {
                NamedChannel nc = (NamedChannel)broadcastChannelsCombination.get(i);
                PlanNode bcSource = nc.getSource();
                if (!this.areBranchCompatible(bcSource, inputSource)) {
                    validCombination = false;
                    break;
                }
                for (int k = 0; k < i; ++k) {
                    PlanNode otherBcSource = ((NamedChannel)broadcastChannelsCombination.get(k)).getSource();
                    if (this.areBranchCompatible(bcSource, otherBcSource)) continue;
                    validCombination = false;
                    break;
                }
                if (!in.isOnDynamicPath() || this.hereJoinedBranches == null) continue;
                for (OptimizerNode brancher : this.hereJoinedBranches) {
                    PlanNode candAtBrancher = in.getSource().getCandidateAtBranchPoint(brancher);
                    if (candAtBrancher == null) continue;
                    PlanNode.SourceAndDamReport res = in.getSource().hasDamOnPathDownTo(candAtBrancher);
                    if (res == PlanNode.SourceAndDamReport.NOT_FOUND) {
                        throw new CompilerException("Bug: Tracing dams for deadlock detection is broken.");
                    }
                    if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
                        requiresPipelinebreaker = true;
                        continue block1;
                    }
                    if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) continue;
                    throw new CompilerException();
                }
            }
            if (!validCombination) continue;
            if (requiresPipelinebreaker) {
                in.setTempMode(in.getTempMode().makePipelineBreaker());
            }
            SingleInputPlanNode node = dps.instantiate(in, this);
            node.setBroadcastInputs(broadcastChannelsCombination);
            GlobalProperties gProps = in.getGlobalProperties().clone();
            LocalProperties lProps = in.getLocalProperties().clone();
            gProps = dps.computeGlobalProperties(gProps);
            lProps = dps.computeLocalProperties(lProps);
            gProps = gProps.filterBySemanticProperties(this.getSemanticPropertiesForGlobalPropertyFiltering(), 0);
            lProps = lProps.filterBySemanticProperties(this.getSemanticPropertiesForLocalPropertyFiltering(), 0);
            node.initProperties(gProps, lProps);
            node.updatePropertiesWithUniqueSets(this.getUniqueFields());
            target.add(node);
        }
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        this.addClosedBranches(this.getPredecessorNode().closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> fromInput = this.getPredecessorNode().getBranchesForParent(this.inConn);
        List<OptimizerNode.UnclosedBranchDescriptor> result = this.computeUnclosedBranchStackForBroadcastInputs(fromInput);
        this.openBranches = result == null || result.isEmpty() ? Collections.emptyList() : result;
    }

    @Override
    public void accept(Visitor<OptimizerNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            if (this.getPredecessorNode() == null) {
                throw new CompilerException();
            }
            this.getPredecessorNode().accept(visitor);
            for (DagConnection connection : this.getBroadcastConnections()) {
                connection.getSource().accept(visitor);
            }
            visitor.postVisit((Visitable)this);
        }
    }
}

