/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.io.IOException;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.partition.consumer.CheckpointableInput;
import org.apache.flink.streaming.runtime.io.checkpointing.AbstractAlternatingAlignedBarrierHandlerState;
import org.apache.flink.streaming.runtime.io.checkpointing.AlternatingCollectingBarriersUnaligned;
import org.apache.flink.streaming.runtime.io.checkpointing.BarrierHandlerState;
import org.apache.flink.streaming.runtime.io.checkpointing.ChannelState;
import org.apache.flink.util.Preconditions;

final class AlternatingCollectingBarriers
extends AbstractAlternatingAlignedBarrierHandlerState {
    AlternatingCollectingBarriers(ChannelState context) {
        super(context);
    }

    @Override
    public BarrierHandlerState alignedCheckpointTimeout(BarrierHandlerState.Controller controller, CheckpointBarrier checkpointBarrier) throws IOException, CheckpointException {
        this.state.prioritizeAllAnnouncements();
        CheckpointBarrier unalignedBarrier = checkpointBarrier.asUnaligned();
        controller.initInputsCheckpoint(unalignedBarrier);
        for (CheckpointableInput input : this.state.getInputs()) {
            input.checkpointStarted(unalignedBarrier);
        }
        controller.triggerGlobalCheckpoint(unalignedBarrier);
        return new AlternatingCollectingBarriersUnaligned(true, this.state);
    }

    @Override
    public BarrierHandlerState endOfPartitionReceived(BarrierHandlerState.Controller controller, InputChannelInfo channelInfo) throws IOException, CheckpointException {
        this.state.channelFinished(channelInfo);
        CheckpointBarrier pendingCheckpointBarrier = controller.getPendingCheckpointBarrier();
        Preconditions.checkState((pendingCheckpointBarrier != null ? 1 : 0) != 0, (Object)"At least one barrier received in collecting barrier state.");
        Preconditions.checkState((!pendingCheckpointBarrier.getCheckpointOptions().isUnalignedCheckpoint() ? 1 : 0) != 0, (Object)"Pending checkpoint barrier should be aligned in collecting aligned barrier state");
        if (controller.allBarriersReceived()) {
            controller.initInputsCheckpoint(pendingCheckpointBarrier);
            controller.triggerGlobalCheckpoint(pendingCheckpointBarrier);
            return this.finishCheckpoint();
        }
        if (controller.isTimedOut(pendingCheckpointBarrier)) {
            return this.alignedCheckpointTimeout(controller, pendingCheckpointBarrier).endOfPartitionReceived(controller, channelInfo);
        }
        return this;
    }

    @Override
    protected BarrierHandlerState transitionAfterBarrierReceived(ChannelState state) {
        return this;
    }
}

