/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.KinesisStreamingSourceOptions;
import software.amazon.awssdk.services.glue.model.StreamingDataPreviewOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CatalogKinesisSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CatalogKinesisSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CatalogKinesisSource.getter(CatalogKinesisSource::name)).setter(CatalogKinesisSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> WINDOW_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WindowSize").getter(CatalogKinesisSource.getter(CatalogKinesisSource::windowSize)).setter(CatalogKinesisSource.setter(Builder::windowSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowSize").build()}).build();
    private static final SdkField<Boolean> DETECT_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DetectSchema").getter(CatalogKinesisSource.getter(CatalogKinesisSource::detectSchema)).setter(CatalogKinesisSource.setter(Builder::detectSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectSchema").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(CatalogKinesisSource.getter(CatalogKinesisSource::table)).setter(CatalogKinesisSource.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(CatalogKinesisSource.getter(CatalogKinesisSource::database)).setter(CatalogKinesisSource.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<KinesisStreamingSourceOptions> STREAMING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamingOptions").getter(CatalogKinesisSource.getter(CatalogKinesisSource::streamingOptions)).setter(CatalogKinesisSource.setter(Builder::streamingOptions)).constructor(KinesisStreamingSourceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingOptions").build()}).build();
    private static final SdkField<StreamingDataPreviewOptions> DATA_PREVIEW_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataPreviewOptions").getter(CatalogKinesisSource.getter(CatalogKinesisSource::dataPreviewOptions)).setter(CatalogKinesisSource.setter(Builder::dataPreviewOptions)).constructor(StreamingDataPreviewOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPreviewOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, WINDOW_SIZE_FIELD, DETECT_SCHEMA_FIELD, TABLE_FIELD, DATABASE_FIELD, STREAMING_OPTIONS_FIELD, DATA_PREVIEW_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer windowSize;
    private final Boolean detectSchema;
    private final String table;
    private final String database;
    private final KinesisStreamingSourceOptions streamingOptions;
    private final StreamingDataPreviewOptions dataPreviewOptions;

    private CatalogKinesisSource(BuilderImpl builder) {
        this.name = builder.name;
        this.windowSize = builder.windowSize;
        this.detectSchema = builder.detectSchema;
        this.table = builder.table;
        this.database = builder.database;
        this.streamingOptions = builder.streamingOptions;
        this.dataPreviewOptions = builder.dataPreviewOptions;
    }

    public final String name() {
        return this.name;
    }

    public final Integer windowSize() {
        return this.windowSize;
    }

    public final Boolean detectSchema() {
        return this.detectSchema;
    }

    public final String table() {
        return this.table;
    }

    public final String database() {
        return this.database;
    }

    public final KinesisStreamingSourceOptions streamingOptions() {
        return this.streamingOptions;
    }

    public final StreamingDataPreviewOptions dataPreviewOptions() {
        return this.dataPreviewOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPreviewOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogKinesisSource)) {
            return false;
        }
        CatalogKinesisSource other = (CatalogKinesisSource)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.windowSize(), other.windowSize()) && Objects.equals(this.detectSchema(), other.detectSchema()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.streamingOptions(), other.streamingOptions()) && Objects.equals(this.dataPreviewOptions(), other.dataPreviewOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CatalogKinesisSource").add("Name", (Object)this.name()).add("WindowSize", (Object)this.windowSize()).add("DetectSchema", (Object)this.detectSchema()).add("Table", (Object)this.table()).add("Database", (Object)this.database()).add("StreamingOptions", (Object)this.streamingOptions()).add("DataPreviewOptions", (Object)this.dataPreviewOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "WindowSize": {
                return Optional.ofNullable(clazz.cast(this.windowSize()));
            }
            case "DetectSchema": {
                return Optional.ofNullable(clazz.cast(this.detectSchema()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "StreamingOptions": {
                return Optional.ofNullable(clazz.cast(this.streamingOptions()));
            }
            case "DataPreviewOptions": {
                return Optional.ofNullable(clazz.cast(this.dataPreviewOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CatalogKinesisSource, T> g) {
        return obj -> g.apply((CatalogKinesisSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer windowSize;
        private Boolean detectSchema;
        private String table;
        private String database;
        private KinesisStreamingSourceOptions streamingOptions;
        private StreamingDataPreviewOptions dataPreviewOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogKinesisSource model) {
            this.name(model.name);
            this.windowSize(model.windowSize);
            this.detectSchema(model.detectSchema);
            this.table(model.table);
            this.database(model.database);
            this.streamingOptions(model.streamingOptions);
            this.dataPreviewOptions(model.dataPreviewOptions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getWindowSize() {
            return this.windowSize;
        }

        public final void setWindowSize(Integer windowSize) {
            this.windowSize = windowSize;
        }

        @Override
        public final Builder windowSize(Integer windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public final Boolean getDetectSchema() {
            return this.detectSchema;
        }

        public final void setDetectSchema(Boolean detectSchema) {
            this.detectSchema = detectSchema;
        }

        @Override
        public final Builder detectSchema(Boolean detectSchema) {
            this.detectSchema = detectSchema;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final KinesisStreamingSourceOptions.Builder getStreamingOptions() {
            return this.streamingOptions != null ? this.streamingOptions.toBuilder() : null;
        }

        public final void setStreamingOptions(KinesisStreamingSourceOptions.BuilderImpl streamingOptions) {
            this.streamingOptions = streamingOptions != null ? streamingOptions.build() : null;
        }

        @Override
        public final Builder streamingOptions(KinesisStreamingSourceOptions streamingOptions) {
            this.streamingOptions = streamingOptions;
            return this;
        }

        public final StreamingDataPreviewOptions.Builder getDataPreviewOptions() {
            return this.dataPreviewOptions != null ? this.dataPreviewOptions.toBuilder() : null;
        }

        public final void setDataPreviewOptions(StreamingDataPreviewOptions.BuilderImpl dataPreviewOptions) {
            this.dataPreviewOptions = dataPreviewOptions != null ? dataPreviewOptions.build() : null;
        }

        @Override
        public final Builder dataPreviewOptions(StreamingDataPreviewOptions dataPreviewOptions) {
            this.dataPreviewOptions = dataPreviewOptions;
            return this;
        }

        public CatalogKinesisSource build() {
            return new CatalogKinesisSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CatalogKinesisSource> {
        public Builder name(String var1);

        public Builder windowSize(Integer var1);

        public Builder detectSchema(Boolean var1);

        public Builder table(String var1);

        public Builder database(String var1);

        public Builder streamingOptions(KinesisStreamingSourceOptions var1);

        default public Builder streamingOptions(Consumer<KinesisStreamingSourceOptions.Builder> streamingOptions) {
            return this.streamingOptions((KinesisStreamingSourceOptions)((KinesisStreamingSourceOptions.Builder)KinesisStreamingSourceOptions.builder().applyMutation(streamingOptions)).build());
        }

        public Builder dataPreviewOptions(StreamingDataPreviewOptions var1);

        default public Builder dataPreviewOptions(Consumer<StreamingDataPreviewOptions.Builder> dataPreviewOptions) {
            return this.dataPreviewOptions((StreamingDataPreviewOptions)((StreamingDataPreviewOptions.Builder)StreamingDataPreviewOptions.builder().applyMutation(dataPreviewOptions)).build());
        }
    }
}

