/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HudiTargetCompressionType {
    GZIP("gzip"),
    LZO("lzo"),
    UNCOMPRESSED("uncompressed"),
    SNAPPY("snappy"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HudiTargetCompressionType> VALUE_MAP;
    private final String value;

    private HudiTargetCompressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HudiTargetCompressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HudiTargetCompressionType> knownValues() {
        EnumSet<HudiTargetCompressionType> knownValues = EnumSet.allOf(HudiTargetCompressionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HudiTargetCompressionType.class, HudiTargetCompressionType::toString);
    }
}

