/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceControlAuthStrategy {
    PERSONAL_ACCESS_TOKEN("PERSONAL_ACCESS_TOKEN"),
    AWS_SECRETS_MANAGER("AWS_SECRETS_MANAGER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceControlAuthStrategy> VALUE_MAP;
    private final String value;

    private SourceControlAuthStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceControlAuthStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceControlAuthStrategy> knownValues() {
        EnumSet<SourceControlAuthStrategy> knownValues = EnumSet.allOf(SourceControlAuthStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceControlAuthStrategy.class, SourceControlAuthStrategy::toString);
    }
}

