/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse;

public class GetDevEndpointsIterable
implements SdkIterable<GetDevEndpointsResponse> {
    private final GlueClient client;
    private final GetDevEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDevEndpointsIterable(GlueClient client, GetDevEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetDevEndpointsResponseFetcher();
    }

    public Iterator<GetDevEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetDevEndpointsResponseFetcher
    implements SyncPageFetcher<GetDevEndpointsResponse> {
        private GetDevEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(GetDevEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDevEndpointsResponse nextPage(GetDevEndpointsResponse previousPage) {
            if (previousPage == null) {
                return GetDevEndpointsIterable.this.client.getDevEndpoints(GetDevEndpointsIterable.this.firstRequest);
            }
            return GetDevEndpointsIterable.this.client.getDevEndpoints((GetDevEndpointsRequest)((Object)GetDevEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

