/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public enum RowLevelOperationMode {
    COPY_ON_WRITE("copy-on-write"),
    MERGE_ON_READ("merge-on-read");

    private final String modeName;

    private RowLevelOperationMode(String modeName) {
        this.modeName = modeName;
    }

    public static RowLevelOperationMode fromName(String modeName) {
        Preconditions.checkArgument((modeName != null ? 1 : 0) != 0, (Object)"Mode name is null");
        if (COPY_ON_WRITE.modeName().equalsIgnoreCase(modeName)) {
            return COPY_ON_WRITE;
        }
        if (MERGE_ON_READ.modeName().equalsIgnoreCase(modeName)) {
            return MERGE_ON_READ;
        }
        throw new IllegalArgumentException("Unknown row-level operation mode: " + modeName);
    }

    public String modeName() {
        return this.modeName;
    }
}

