/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.spark.TaskContext$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.BoxedUnit;

public final class CodecStreams$ {
    public static CodecStreams$ MODULE$;

    static {
        new CodecStreams$();
    }

    private Option<CompressionCodec> getDecompressionCodec(Configuration config, Path file) {
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(config);
        return Option$.MODULE$.apply((Object)compressionCodecs.getCodec(file));
    }

    public InputStream createInputStream(Configuration config, Path file) {
        FileSystem fs = file.getFileSystem(config);
        FSDataInputStream inputStream = fs.open(file);
        return (InputStream)this.getDecompressionCodec(config, file).map(arg_0 -> CodecStreams$.$anonfun$createInputStream$1((InputStream)inputStream, arg_0)).getOrElse(() -> CodecStreams$.$anonfun$createInputStream$2((InputStream)inputStream));
    }

    /*
     * WARNING - void declaration
     */
    public InputStream createInputStreamWithCloseResource(Configuration config, Path path) {
        void var3_3;
        InputStream inputStream = this.createInputStream(config, path);
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
            inputStream.close();
            return BoxedUnit.UNIT;
        }));
        return var3_3;
    }

    private Option<CompressionCodec> getCompressionCodec(JobContext context, Option<Path> file) {
        Option option;
        if (FileOutputFormat.getCompressOutput((JobContext)context)) {
            Class compressorClass = FileOutputFormat.getOutputCompressorClass((JobContext)context, GzipCodec.class);
            option = new Some(ReflectionUtils.newInstance((Class)compressorClass, (Configuration)context.getConfiguration()));
        } else {
            option = file.flatMap((Function1 & Serializable & scala.Serializable)path -> {
                CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(context.getConfiguration());
                return Option$.MODULE$.apply((Object)compressionCodecs.getCodec(path));
            });
        }
        return option;
    }

    private Option<Path> getCompressionCodec$default$2() {
        return None$.MODULE$;
    }

    public OutputStream createOutputStream(JobContext context, Path file) {
        FileSystem fs = file.getFileSystem(context.getConfiguration());
        FSDataOutputStream outputStream = fs.create(file, false);
        return (OutputStream)this.getCompressionCodec(context, (Option<Path>)new Some((Object)file)).map(arg_0 -> CodecStreams$.$anonfun$createOutputStream$1((OutputStream)outputStream, arg_0)).getOrElse(() -> CodecStreams$.$anonfun$createOutputStream$2((OutputStream)outputStream));
    }

    public OutputStreamWriter createOutputStreamWriter(JobContext context, Path file, Charset charset) {
        return new OutputStreamWriter(this.createOutputStream(context, file), charset);
    }

    public Charset createOutputStreamWriter$default$3() {
        return StandardCharsets.UTF_8;
    }

    public String getCompressionExtension(JobContext context) {
        return (String)this.getCompressionCodec(context, this.getCompressionCodec$default$2()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getDefaultExtension()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public static final /* synthetic */ CompressionInputStream $anonfun$createInputStream$1(InputStream inputStream$1, CompressionCodec codec) {
        return codec.createInputStream(inputStream$1);
    }

    public static final /* synthetic */ InputStream $anonfun$createInputStream$2(InputStream inputStream$1) {
        return inputStream$1;
    }

    public static final /* synthetic */ CompressionOutputStream $anonfun$createOutputStream$1(OutputStream outputStream$1, CompressionCodec codec) {
        return codec.createOutputStream(outputStream$1);
    }

    public static final /* synthetic */ OutputStream $anonfun$createOutputStream$2(OutputStream outputStream$1) {
        return outputStream$1;
    }

    private CodecStreams$() {
        MODULE$ = this;
    }
}

