/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.utils;

import java.util.Optional;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUrlUtil {
    private static final String SCHEME_SEPARATOR = "://";
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final Logger LOG = LoggerFactory.getLogger(LogUrlUtil.class);

    public static Optional<String> getValidLogUrlPattern(Configuration config, ConfigOption<String> option) {
        String pattern = (String)config.get(option);
        if (StringUtils.isNullOrWhitespaceOnly((String)pattern)) {
            return Optional.empty();
        }
        String scheme = (pattern = pattern.trim()).substring(0, Math.max(pattern.indexOf(SCHEME_SEPARATOR), 0));
        if (scheme.isEmpty()) {
            return Optional.of("http://" + pattern);
        }
        if (HTTP_SCHEME.equalsIgnoreCase(scheme) || HTTPS_SCHEME.equalsIgnoreCase(scheme)) {
            return Optional.of(pattern);
        }
        LOG.warn("Ignore configured value for '{}': unsupported scheme {}", (Object)option.key(), (Object)scheme);
        return Optional.empty();
    }

    private LogUrlUtil() {
    }
}

