/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageInputChannelId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyService;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.AvailabilityNotifier;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManagerImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.util.Preconditions;

public class TieredStorageConsumerClient {
    private final List<TierFactory> tierFactories;
    private final TieredStorageNettyService nettyService;
    private final List<TierConsumerAgent> tierConsumerAgents;
    private final Map<TieredStoragePartitionId, Map<TieredStorageSubpartitionId, Tuple2<TierConsumerAgent, Integer>>> currentConsumerAgentAndSegmentIds = new HashMap<TieredStoragePartitionId, Map<TieredStorageSubpartitionId, Tuple2<TierConsumerAgent, Integer>>>();

    public TieredStorageConsumerClient(List<TierFactory> tierFactories, List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs, List<List<TierShuffleDescriptor>> tierShuffleDescriptors, TieredStorageNettyService nettyService) {
        this.tierFactories = tierFactories;
        this.nettyService = nettyService;
        this.tierConsumerAgents = this.createTierConsumerAgents(tieredStorageConsumerSpecs, tierShuffleDescriptors);
    }

    public void setup(BufferPool bufferPool) {
        TieredStorageMemoryManagerImpl memoryManager = new TieredStorageMemoryManagerImpl(0.0f, false);
        memoryManager.setup(bufferPool, Collections.emptyList());
        this.tierConsumerAgents.forEach(tierConsumerAgent -> tierConsumerAgent.setup(memoryManager));
    }

    public void start() {
        for (TierConsumerAgent tierConsumerAgent : this.tierConsumerAgents) {
            tierConsumerAgent.start();
        }
    }

    public int peekNextBufferSubpartitionId(TieredStoragePartitionId partitionId, ResultSubpartitionIndexSet indexSet) throws IOException {
        for (TierConsumerAgent tierConsumerAgent : this.tierConsumerAgents) {
            int subpartitionId = tierConsumerAgent.peekNextBufferSubpartitionId(partitionId, indexSet);
            if (subpartitionId < 0) continue;
            return subpartitionId;
        }
        return -1;
    }

    public Optional<Buffer> getNextBuffer(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subpartitionId) throws IOException {
        Tuple2 currentConsumerAgentAndSegmentId = this.currentConsumerAgentAndSegmentIds.computeIfAbsent(partitionId, ignore -> new HashMap()).getOrDefault(subpartitionId, Tuple2.of(null, (Object)0));
        Optional<Object> buffer = Optional.empty();
        if (currentConsumerAgentAndSegmentId.f0 == null) {
            for (TierConsumerAgent tierConsumerAgent : this.tierConsumerAgents) {
                buffer = tierConsumerAgent.getNextBuffer(partitionId, subpartitionId, (Integer)currentConsumerAgentAndSegmentId.f1);
                if (!buffer.isPresent()) continue;
                this.currentConsumerAgentAndSegmentIds.get(partitionId).put(subpartitionId, (Tuple2<TierConsumerAgent, Integer>)Tuple2.of((Object)tierConsumerAgent, (Object)currentConsumerAgentAndSegmentId.f1));
                break;
            }
        } else {
            buffer = ((TierConsumerAgent)currentConsumerAgentAndSegmentId.f0).getNextBuffer(partitionId, subpartitionId, (Integer)currentConsumerAgentAndSegmentId.f1);
        }
        if (!buffer.isPresent()) {
            return Optional.empty();
        }
        Buffer bufferData = (Buffer)buffer.get();
        if (bufferData.getDataType() == Buffer.DataType.END_OF_SEGMENT) {
            this.currentConsumerAgentAndSegmentIds.get(partitionId).put(subpartitionId, (Tuple2<TierConsumerAgent, Integer>)Tuple2.of(null, (Object)((Integer)currentConsumerAgentAndSegmentId.f1 + 1)));
            bufferData.recycleBuffer();
            return this.getNextBuffer(partitionId, subpartitionId);
        }
        return Optional.of(bufferData);
    }

    public void registerAvailabilityNotifier(AvailabilityNotifier notifier) {
        for (TierConsumerAgent tierConsumerAgent : this.tierConsumerAgents) {
            tierConsumerAgent.registerAvailabilityNotifier(notifier);
        }
    }

    public void updateTierShuffleDescriptors(TieredStoragePartitionId partitionId, TieredStorageInputChannelId inputChannelId, TieredStorageSubpartitionId subpartitionId, List<TierShuffleDescriptor> tierShuffleDescriptors) {
        Preconditions.checkState((tierShuffleDescriptors.size() == this.tierConsumerAgents.size() ? 1 : 0) != 0);
        for (int i = 0; i < tierShuffleDescriptors.size(); ++i) {
            this.tierConsumerAgents.get(i).updateTierShuffleDescriptor(partitionId, inputChannelId, subpartitionId, tierShuffleDescriptors.get(i));
        }
    }

    public void close() throws IOException {
        for (TierConsumerAgent tierConsumerAgent : this.tierConsumerAgents) {
            tierConsumerAgent.close();
        }
    }

    private List<TierConsumerAgent> createTierConsumerAgents(List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs, List<List<TierShuffleDescriptor>> shuffleDescriptors) {
        ArrayList<TierConsumerAgent> tierConsumerAgents = new ArrayList<TierConsumerAgent>();
        List<List<TierShuffleDescriptor>> transformedTierShuffleDescriptors = TieredStorageConsumerClient.transformTierShuffleDescriptors(shuffleDescriptors);
        Preconditions.checkState((transformedTierShuffleDescriptors.size() == this.tierFactories.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.tierFactories.size(); ++i) {
            tierConsumerAgents.add(this.tierFactories.get(i).createConsumerAgent(tieredStorageConsumerSpecs, transformedTierShuffleDescriptors.get(i), this.nettyService));
        }
        return tierConsumerAgents;
    }

    private static List<List<TierShuffleDescriptor>> transformTierShuffleDescriptors(List<List<TierShuffleDescriptor>> shuffleDescriptors) {
        int numTiers = 0;
        int numPartitions = shuffleDescriptors.size();
        for (List<TierShuffleDescriptor> tierShuffleDescriptors : shuffleDescriptors) {
            if (numTiers == 0) {
                numTiers = tierShuffleDescriptors.size();
            }
            Preconditions.checkState((numTiers == tierShuffleDescriptors.size() ? 1 : 0) != 0);
        }
        ArrayList<List<TierShuffleDescriptor>> transformedList = new ArrayList<List<TierShuffleDescriptor>>();
        for (int i = 0; i < numTiers; ++i) {
            ArrayList<TierShuffleDescriptor> innerList = new ArrayList<TierShuffleDescriptor>();
            for (int j = 0; j < numPartitions; ++j) {
                innerList.add(shuffleDescriptors.get(j).get(i));
            }
            transformedList.add(innerList);
        }
        return transformedList;
    }
}

