/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.apache.flink.runtime.metrics.filter.DefaultMetricFilter;
import org.apache.flink.runtime.metrics.filter.MetricFilter;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.shaded.guava31.com.google.common.collect.Iterators;
import org.apache.flink.traces.reporter.TraceReporterFactory;
import org.apache.flink.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReporterSetup {
    private static final Logger LOG = LoggerFactory.getLogger(ReporterSetup.class);
    private static final Pattern metricReporterListPattern = Pattern.compile("\\s*,\\s*");
    private static final Pattern metricReporterClassPattern = Pattern.compile(Pattern.quote("metrics.reporter.") + "([\\S&&[^.]]*)\\." + '(' + Pattern.quote(MetricOptions.REPORTER_CLASS.key()) + '|' + Pattern.quote(MetricOptions.REPORTER_FACTORY_CLASS.key()) + ')');
    private final String name;
    private final MetricConfig configuration;
    private final MetricReporter reporter;
    private final MetricFilter filter;
    private final Map<String, String> additionalVariables;

    public ReporterSetup(String name, MetricConfig configuration, MetricReporter reporter, MetricFilter filter, Map<String, String> additionalVariables) {
        this.name = name;
        this.configuration = configuration;
        this.reporter = reporter;
        this.filter = filter;
        this.additionalVariables = additionalVariables;
    }

    public Optional<String> getDelimiter() {
        return Optional.ofNullable(this.configuration.getString(MetricOptions.REPORTER_SCOPE_DELIMITER.key(), null));
    }

    public Optional<String> getIntervalSettings() {
        return Optional.ofNullable(this.configuration.getString(MetricOptions.REPORTER_INTERVAL.key(), null));
    }

    public Set<String> getExcludedVariables() {
        String excludedVariablesList = this.configuration.getString(MetricOptions.REPORTER_EXCLUDED_VARIABLES.key(), null);
        if (excludedVariablesList == null) {
            return Collections.emptySet();
        }
        HashSet<String> excludedVariables = new HashSet<String>();
        for (String exclusion : excludedVariablesList.split(";")) {
            excludedVariables.add(ScopeFormat.asVariable(exclusion));
        }
        return Collections.unmodifiableSet(excludedVariables);
    }

    public MetricFilter getFilter() {
        return this.filter;
    }

    public Map<String, String> getAdditionalVariables() {
        return this.additionalVariables;
    }

    public String getName() {
        return this.name;
    }

    @VisibleForTesting
    MetricConfig getConfiguration() {
        return this.configuration;
    }

    public MetricReporter getReporter() {
        return this.reporter;
    }

    @VisibleForTesting
    public static ReporterSetup forReporter(String reporterName, MetricReporter reporter) {
        return ReporterSetup.createReporterSetup(reporterName, new MetricConfig(), reporter, MetricFilter.NO_OP_FILTER, Collections.emptyMap());
    }

    @VisibleForTesting
    public static ReporterSetup forReporter(String reporterName, MetricConfig metricConfig, MetricReporter reporter) {
        return ReporterSetup.createReporterSetup(reporterName, metricConfig, reporter, MetricFilter.NO_OP_FILTER, Collections.emptyMap());
    }

    @VisibleForTesting
    public static ReporterSetup forReporter(String reporterName, MetricFilter metricFilter, MetricReporter reporter) {
        return ReporterSetup.createReporterSetup(reporterName, new MetricConfig(), reporter, metricFilter, Collections.emptyMap());
    }

    private static ReporterSetup createReporterSetup(String reporterName, MetricConfig metricConfig, MetricReporter reporter, MetricFilter metricFilter, Map<String, String> additionalVariables) {
        reporter.open(metricConfig);
        return new ReporterSetup(reporterName, metricConfig, reporter, metricFilter, additionalVariables);
    }

    public static List<ReporterSetup> fromConfiguration(Configuration configuration, @Nullable PluginManager pluginManager) {
        String includedReportersString = (String)configuration.get(MetricOptions.REPORTERS_LIST, (Object)"");
        Set<String> namedReporters = ReporterSetup.findEnabledTraceReportersInConfiguration(configuration, includedReportersString, metricReporterListPattern, metricReporterClassPattern, "metrics.reporter.");
        if (namedReporters.isEmpty()) {
            return Collections.emptyList();
        }
        List<Tuple2<String, Configuration>> reporterConfigurations = ReporterSetup.loadReporterConfigurations(configuration, namedReporters, "metrics.reporter.");
        Map<String, MetricReporterFactory> reporterFactories = ReporterSetup.loadAvailableReporterFactories(pluginManager);
        return ReporterSetup.setupReporters(reporterFactories, reporterConfigurations);
    }

    public static Set<String> findEnabledTraceReportersInConfiguration(Configuration configuration, String includedReportersString, Pattern reporterListPattern, Pattern reporterClassPattern, String reporterPrefix) {
        Set includedReporters = reporterListPattern.splitAsStream(includedReportersString).filter(r -> !r.isEmpty()).collect(Collectors.toSet());
        TreeSet<String> namedOrderedReporters = new TreeSet<String>(String::compareTo);
        for (String key : configuration.keySet()) {
            Matcher matcher;
            if (!key.startsWith(reporterPrefix) || !(matcher = reporterClassPattern.matcher(key)).matches()) continue;
            String reporterName = matcher.group(1);
            if (includedReporters.isEmpty() || includedReporters.contains(reporterName)) {
                if (namedOrderedReporters.contains(reporterName)) {
                    LOG.warn("Duplicate class configuration detected for {}{}.", (Object)reporterPrefix.replace('.', ' '), (Object)reporterName);
                    continue;
                }
                namedOrderedReporters.add(reporterName);
                continue;
            }
            LOG.info("Excluding {}{}, not configured in reporter list ({}).", new Object[]{reporterPrefix.replace('.', ' '), reporterName, includedReportersString});
        }
        return namedOrderedReporters;
    }

    public static List<Tuple2<String, Configuration>> loadReporterConfigurations(Configuration configuration, Set<String> namedReporters, String reporterPrefix) {
        ArrayList<Tuple2<String, Configuration>> reporterConfigurations = new ArrayList<Tuple2<String, Configuration>>(namedReporters.size());
        for (String namedReporter : namedReporters) {
            DelegatingConfiguration delegatingConfiguration = new DelegatingConfiguration(configuration, reporterPrefix + namedReporter + '.');
            reporterConfigurations.add((Tuple2<String, Configuration>)Tuple2.of((Object)namedReporter, (Object)delegatingConfiguration));
        }
        return reporterConfigurations;
    }

    private static Map<String, MetricReporterFactory> loadAvailableReporterFactories(@Nullable PluginManager pluginManager) {
        HashMap reporterFactories = CollectionUtil.newHashMapWithExpectedSize((int)2);
        Iterator<MetricReporterFactory> factoryIterator = ReporterSetup.getAllReporterFactories(pluginManager);
        while (factoryIterator.hasNext()) {
            try {
                MetricReporterFactory factory = factoryIterator.next();
                String factoryClassName = factory.getClass().getName();
                MetricReporterFactory existingFactory = (MetricReporterFactory)reporterFactories.get(factoryClassName);
                if (existingFactory == null) {
                    reporterFactories.put(factoryClassName, factory);
                    LOG.debug("Found {} {} at {} ", new Object[]{MetricReporterFactory.class.getSimpleName(), factoryClassName, new File(factory.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getCanonicalPath()});
                    continue;
                }
                LOG.warn("Multiple implementations of the same {} were found in 'lib' and/or 'plugins' directories for {}. It is recommended to remove redundant reporter JARs to resolve used versions' ambiguity.", (Object)MetricReporter.class.getSimpleName(), (Object)factoryClassName);
            }
            catch (Exception | ServiceConfigurationError e) {
                LOG.warn("Error while loading {}.", (Object)TraceReporterFactory.class.getSimpleName(), (Object)e);
            }
        }
        return Collections.unmodifiableMap(reporterFactories);
    }

    private static Iterator<MetricReporterFactory> getAllReporterFactories(@Nullable PluginManager pluginManager) {
        Iterator<MetricReporterFactory> factoryIteratorSPI = ServiceLoader.load(MetricReporterFactory.class).iterator();
        Iterator factoryIteratorPlugins = pluginManager != null ? pluginManager.load(MetricReporterFactory.class) : Collections.emptyIterator();
        return Iterators.concat((Iterator)factoryIteratorPlugins, factoryIteratorSPI);
    }

    private static List<ReporterSetup> setupReporters(Map<String, MetricReporterFactory> reporterFactories, List<Tuple2<String, Configuration>> reporterConfigurations) {
        ArrayList<ReporterSetup> reporterSetups = new ArrayList<ReporterSetup>(reporterConfigurations.size());
        for (Tuple2<String, Configuration> reporterConfiguration : reporterConfigurations) {
            String reporterName = (String)reporterConfiguration.f0;
            Configuration reporterConfig = (Configuration)reporterConfiguration.f1;
            try {
                Optional<MetricReporter> metricReporterOptional = ReporterSetup.loadReporter(reporterName, reporterConfig, reporterFactories);
                MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration(reporterConfig);
                Map<String, String> additionalVariables = ((Map)reporterConfig.get(MetricOptions.REPORTER_ADDITIONAL_VARIABLES)).entrySet().stream().collect(Collectors.toMap(e -> ScopeFormat.asVariable((String)e.getKey()), Map.Entry::getValue));
                metricReporterOptional.ifPresent(reporter -> {
                    MetricConfig metricConfig = new MetricConfig();
                    reporterConfig.addAllToProperties((Properties)metricConfig);
                    reporterSetups.add(ReporterSetup.createReporterSetup(reporterName, metricConfig, reporter, metricFilter, additionalVariables));
                });
            }
            catch (Throwable t) {
                LOG.error("Could not instantiate {} {}. Metrics might not be exposed/reported.", new Object[]{MetricReporter.class.getSimpleName(), reporterName, t});
            }
        }
        return reporterSetups;
    }

    private static Optional<MetricReporter> loadReporter(String reporterName, Configuration reporterConfig, Map<String, MetricReporterFactory> reporterFactories) {
        String reporterClassName = (String)reporterConfig.get(MetricOptions.REPORTER_CLASS);
        String factoryClassName = (String)reporterConfig.get(MetricOptions.REPORTER_FACTORY_CLASS);
        if (factoryClassName != null) {
            return ReporterSetup.loadViaFactory(factoryClassName, reporterName, reporterConfig, reporterFactories);
        }
        if (reporterClassName != null) {
            LOG.warn("The reporter configuration of '{}' configures the reporter class, which is no a no longer supported approach to configure reporters. Please configure a factory class instead: '{}{}.{}: <factoryClass>'.", new Object[]{reporterName, "metrics.reporter.", reporterName, MetricOptions.REPORTER_FACTORY_CLASS.key()});
        }
        LOG.warn("No reporter factory set for reporter {}. Metrics might not be exposed/reported.", (Object)reporterName);
        return Optional.empty();
    }

    private static Optional<MetricReporter> loadViaFactory(String factoryClassName, String reporterName, Configuration reporterConfig, Map<String, MetricReporterFactory> reporterFactories) {
        MetricReporterFactory factory = reporterFactories.get(factoryClassName);
        if (factory == null) {
            LOG.warn("The reporter factory ({}) could not be found for reporter {}. Available factories: {}.", new Object[]{factoryClassName, reporterName, reporterFactories.keySet()});
            return Optional.empty();
        }
        return ReporterSetup.loadViaFactory(reporterConfig, factory);
    }

    private static Optional<MetricReporter> loadViaFactory(Configuration reporterConfig, MetricReporterFactory factory) {
        MetricConfig metricConfig = new MetricConfig();
        reporterConfig.addAllToProperties((Properties)metricConfig);
        return Optional.of(factory.createMetricReporter((Properties)metricConfig));
    }
}

