/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.AbstractIncrementalStateHandle;
import org.apache.flink.runtime.state.CheckpointBoundKeyedStateHandle;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalRemoteKeyedStateHandle
extends AbstractIncrementalStateHandle {
    public static final long UNKNOWN_CHECKPOINTED_SIZE = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalRemoteKeyedStateHandle.class);
    private static final long serialVersionUID = -8328808513197388231L;
    private final List<IncrementalKeyedStateHandle.HandleAndLocalPath> privateState;
    private final long persistedSizeOfThisCheckpoint;
    private transient SharedStateRegistry sharedStateRegistry;

    @VisibleForTesting
    public IncrementalRemoteKeyedStateHandle(UUID backendIdentifier, KeyGroupRange keyGroupRange, long checkpointId, List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState, List<IncrementalKeyedStateHandle.HandleAndLocalPath> privateState, StreamStateHandle metaStateHandle) {
        this(backendIdentifier, keyGroupRange, checkpointId, sharedState, privateState, metaStateHandle, -1L, new StateHandleID(UUID.randomUUID().toString()));
    }

    public IncrementalRemoteKeyedStateHandle(UUID backendIdentifier, KeyGroupRange keyGroupRange, long checkpointId, List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState, List<IncrementalKeyedStateHandle.HandleAndLocalPath> privateState, StreamStateHandle metaStateHandle, long persistedSizeOfThisCheckpoint) {
        this(backendIdentifier, keyGroupRange, checkpointId, sharedState, privateState, metaStateHandle, persistedSizeOfThisCheckpoint, new StateHandleID(UUID.randomUUID().toString()));
    }

    protected IncrementalRemoteKeyedStateHandle(UUID backendIdentifier, KeyGroupRange keyGroupRange, long checkpointId, List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState, List<IncrementalKeyedStateHandle.HandleAndLocalPath> privateState, StreamStateHandle metaStateHandle, long persistedSizeOfThisCheckpoint, StateHandleID stateHandleId) {
        super((UUID)Preconditions.checkNotNull((Object)backendIdentifier), (KeyGroupRange)Preconditions.checkNotNull((Object)keyGroupRange), checkpointId, sharedState, metaStateHandle, stateHandleId);
        this.privateState = (List)Preconditions.checkNotNull(privateState);
        this.sharedStateRegistry = null;
        this.persistedSizeOfThisCheckpoint = persistedSizeOfThisCheckpoint == -1L ? this.getStateSize() : persistedSizeOfThisCheckpoint;
    }

    public static IncrementalRemoteKeyedStateHandle restore(UUID backendIdentifier, KeyGroupRange keyGroupRange, long checkpointId, List<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState, List<IncrementalKeyedStateHandle.HandleAndLocalPath> privateState, StreamStateHandle metaStateHandle, long persistedSizeOfThisCheckpoint, StateHandleID stateHandleId) {
        return new IncrementalRemoteKeyedStateHandle(backendIdentifier, keyGroupRange, checkpointId, sharedState, privateState, metaStateHandle, persistedSizeOfThisCheckpoint, stateHandleId);
    }

    @Override
    public CheckpointBoundKeyedStateHandle rebound(long checkpointId) {
        return new IncrementalRemoteKeyedStateHandle(this.backendIdentifier, this.keyGroupRange, checkpointId, this.sharedState, this.privateState, this.metaStateHandle, this.persistedSizeOfThisCheckpoint, this.stateHandleId);
    }

    public List<IncrementalKeyedStateHandle.HandleAndLocalPath> getSharedState() {
        return this.sharedState;
    }

    public List<IncrementalKeyedStateHandle.HandleAndLocalPath> getPrivateState() {
        return this.privateState;
    }

    @Override
    @Nonnull
    public List<IncrementalKeyedStateHandle.HandleAndLocalPath> getSharedStateHandles() {
        return this.getSharedState();
    }

    public SharedStateRegistry getSharedStateRegistry() {
        return this.sharedStateRegistry;
    }

    @Override
    public void discardState() throws Exception {
        SharedStateRegistry registry = this.sharedStateRegistry;
        boolean isRegistered = registry != null;
        LOG.trace("Discarding IncrementalRemoteKeyedStateHandle (registered = {}) for checkpoint {} from backend with id {}.", new Object[]{isRegistered, this.checkpointId, this.backendIdentifier});
        try {
            this.metaStateHandle.discardState();
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard meta data.", (Throwable)e);
        }
        try {
            StateUtil.bestEffortDiscardAllStateObjects(this.privateState.stream().map(IncrementalKeyedStateHandle.HandleAndLocalPath::getHandle).collect(Collectors.toList()));
        }
        catch (Exception e) {
            LOG.warn("Could not properly discard misc file states.", (Throwable)e);
        }
        if (!isRegistered) {
            try {
                StateUtil.bestEffortDiscardAllStateObjects(this.sharedState.stream().map(IncrementalKeyedStateHandle.HandleAndLocalPath::getHandle).collect(Collectors.toList()));
            }
            catch (Exception e) {
                LOG.warn("Could not properly discard new sst file states.", (Throwable)e);
            }
        }
    }

    @Override
    public long getStateSize() {
        return this.streamSubHandles().mapToLong(StateObject::getStateSize).sum();
    }

    @Override
    public void collectSizeStats(StateObject.StateObjectSizeStatsCollector collector) {
        this.streamSubHandles().forEach(handle -> handle.collectSizeStats(collector));
    }

    public Stream<StreamStateHandle> streamSubHandles() {
        return Stream.of(Stream.of(this.metaStateHandle), this.sharedState.stream().map(IncrementalKeyedStateHandle.HandleAndLocalPath::getHandle), this.privateState.stream().map(IncrementalKeyedStateHandle.HandleAndLocalPath::getHandle)).flatMap(Function.identity()).filter(Objects::nonNull);
    }

    @Override
    public long getCheckpointedSize() {
        return this.persistedSizeOfThisCheckpoint;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
        Preconditions.checkState((this.sharedStateRegistry != stateRegistry ? 1 : 0) != 0, (Object)"The state handle has already registered its shared states to the given registry.");
        this.sharedStateRegistry = (SharedStateRegistry)Preconditions.checkNotNull((Object)stateRegistry);
        LOG.trace("Registering IncrementalRemoteKeyedStateHandle for checkpoint {} from backend with id {}.", (Object)this.checkpointId, (Object)this.backendIdentifier);
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : this.sharedState) {
            StreamStateHandle reference = stateRegistry.registerReference(SharedStateRegistryKey.forStreamStateHandle(handleAndLocalPath.getHandle()), handleAndLocalPath.getHandle(), checkpointID);
            handleAndLocalPath.replaceHandle(reference);
        }
    }

    @VisibleForTesting
    IncrementalRemoteKeyedStateHandle copy() {
        return new IncrementalRemoteKeyedStateHandle(this.backendIdentifier, this.keyGroupRange, this.checkpointId, this.sharedState, this.privateState, this.metaStateHandle, this.persistedSizeOfThisCheckpoint, this.stateHandleId);
    }

    @Override
    public String toString() {
        return "IncrementalRemoteKeyedStateHandle{privateState=" + this.privateState + ", persistedSizeOfThisCheckpoint=" + this.persistedSizeOfThisCheckpoint + ", registered=" + (this.sharedStateRegistry != null) + "} " + super.toString();
    }
}

