/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class StateSerializerProvider<T> {
    @Nullable
    TypeSerializer<T> registeredSerializer;
    @Nullable
    TypeSerializerSnapshot<T> previousSerializerSnapshot;
    @Nullable
    private TypeSerializer<T> cachedRestoredSerializer;
    private boolean isRegisteredWithIncompatibleSerializer = false;

    public static <T> StateSerializerProvider<T> fromPreviousSerializerSnapshot(TypeSerializerSnapshot<T> stateSerializerSnapshot) {
        return new LazilyRegisteredStateSerializerProvider<T>(stateSerializerSnapshot);
    }

    public static <T> StateSerializerProvider<T> fromNewRegisteredSerializer(TypeSerializer<T> registeredStateSerializer) {
        return new EagerlyRegisteredStateSerializerProvider<T>(registeredStateSerializer);
    }

    private StateSerializerProvider(@Nonnull TypeSerializer<T> stateSerializer) {
        this.registeredSerializer = stateSerializer;
        this.previousSerializerSnapshot = null;
    }

    private StateSerializerProvider(@Nonnull TypeSerializerSnapshot<T> previousSerializerSnapshot) {
        this.previousSerializerSnapshot = previousSerializerSnapshot;
        this.registeredSerializer = null;
    }

    @Nonnull
    public final TypeSerializer<T> currentSchemaSerializer() {
        if (this.registeredSerializer != null) {
            Preconditions.checkState((!this.isRegisteredWithIncompatibleSerializer ? 1 : 0) != 0, (Object)"Unable to provide a serializer with the current schema, because the restored state was registered with a new serializer that has incompatible schema.");
            return this.registeredSerializer;
        }
        return this.previousSchemaSerializer();
    }

    @Nonnull
    public final TypeSerializer<T> previousSchemaSerializer() {
        if (this.cachedRestoredSerializer != null) {
            return this.cachedRestoredSerializer;
        }
        if (this.previousSerializerSnapshot == null) {
            throw new UnsupportedOperationException("This provider does not contain the state's previous serializer's snapshot. Cannot provider a serializer for previous schema.");
        }
        this.cachedRestoredSerializer = this.previousSerializerSnapshot.restoreSerializer();
        return this.cachedRestoredSerializer;
    }

    @Nullable
    public final TypeSerializerSnapshot<T> getPreviousSerializerSnapshot() {
        return this.previousSerializerSnapshot;
    }

    @Nonnull
    public abstract TypeSerializerSchemaCompatibility<T> registerNewSerializerForRestoredState(TypeSerializer<T> var1);

    @Nonnull
    public abstract TypeSerializerSchemaCompatibility<T> setPreviousSerializerSnapshotForRestoredState(TypeSerializerSnapshot<T> var1);

    protected final void invalidateCurrentSchemaSerializerAccess() {
        this.isRegisteredWithIncompatibleSerializer = true;
    }

    private static class EagerlyRegisteredStateSerializerProvider<T>
    extends StateSerializerProvider<T> {
        EagerlyRegisteredStateSerializerProvider(TypeSerializer<T> registeredStateSerializer) {
            super((TypeSerializer)Preconditions.checkNotNull(registeredStateSerializer));
        }

        @Override
        @Nonnull
        public TypeSerializerSchemaCompatibility<T> registerNewSerializerForRestoredState(TypeSerializer<T> newSerializer) {
            throw new UnsupportedOperationException("A serializer has already been registered for the state; re-registration is not allowed.");
        }

        @Override
        @Nonnull
        public TypeSerializerSchemaCompatibility<T> setPreviousSerializerSnapshotForRestoredState(TypeSerializerSnapshot<T> previousSerializerSnapshot) {
            Preconditions.checkNotNull(previousSerializerSnapshot);
            if (this.previousSerializerSnapshot != null) {
                throw new UnsupportedOperationException("The snapshot of the state's previous serializer has already been set; cannot reset.");
            }
            this.previousSerializerSnapshot = previousSerializerSnapshot;
            TypeSerializerSchemaCompatibility result = ((TypeSerializer)Preconditions.checkNotNull((Object)this.registeredSerializer)).snapshotConfiguration().resolveSchemaCompatibility(previousSerializerSnapshot);
            if (result.isIncompatible()) {
                this.invalidateCurrentSchemaSerializerAccess();
            }
            if (result.isCompatibleWithReconfiguredSerializer()) {
                this.registeredSerializer = result.getReconfiguredSerializer();
            }
            return result;
        }
    }

    private static class LazilyRegisteredStateSerializerProvider<T>
    extends StateSerializerProvider<T> {
        LazilyRegisteredStateSerializerProvider(TypeSerializerSnapshot<T> previousSerializerSnapshot) {
            super((TypeSerializerSnapshot)Preconditions.checkNotNull(previousSerializerSnapshot));
        }

        @Override
        @Nonnull
        public TypeSerializerSchemaCompatibility<T> registerNewSerializerForRestoredState(TypeSerializer<T> newSerializer) {
            Preconditions.checkNotNull(newSerializer);
            if (this.registeredSerializer != null) {
                throw new UnsupportedOperationException("A serializer has already been registered for the state; re-registration is not allowed.");
            }
            TypeSerializerSchemaCompatibility result = newSerializer.snapshotConfiguration().resolveSchemaCompatibility(this.previousSerializerSnapshot);
            if (result.isIncompatible()) {
                this.invalidateCurrentSchemaSerializerAccess();
            }
            this.registeredSerializer = result.isCompatibleWithReconfiguredSerializer() ? result.getReconfiguredSerializer() : newSerializer;
            return result;
        }

        @Override
        @Nonnull
        public TypeSerializerSchemaCompatibility<T> setPreviousSerializerSnapshotForRestoredState(TypeSerializerSnapshot<T> previousSerializerSnapshot) {
            throw new UnsupportedOperationException("The snapshot of the state's previous serializer has already been set; cannot reset.");
        }
    }
}

