/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.Attributes;
import com.linecorp.armeria.common.AttributesBuilder;
import com.linecorp.armeria.common.AttributesGetters;
import com.linecorp.armeria.common.ConcurrentAttributes;
import com.linecorp.armeria.common.ImmutableAttributesBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterators;
import io.netty.util.AttributeKey;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

final class ImmutableAttributes
implements Attributes {
    static final Attributes EMPTY = new ImmutableAttributes(null, ImmutableMap.of());
    @Nullable
    private final AttributesGetters parent;
    private final Map<AttributeKey<?>, Object> attributes;

    ImmutableAttributes(@Nullable AttributesGetters parent, Map<AttributeKey<?>, Object> attributes) {
        this.parent = parent;
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    @Override
    public AttributesBuilder toBuilder() {
        ImmutableAttributesBuilder builder = new ImmutableAttributesBuilder(this.parent);
        this.attributes.forEach((k, v) -> builder.set((AttributeKey)k, v));
        return builder;
    }

    @Override
    public ConcurrentAttributes toConcurrentAttributes() {
        ConcurrentAttributes concurrentAttributes = this.parent == null ? ConcurrentAttributes.of() : ConcurrentAttributes.fromParent(this.parent);
        if (!this.attributes.isEmpty()) {
            this.attributes.forEach((k, v) -> {
                if (v == ImmutableAttributesBuilder.NULL_VALUE) {
                    v = null;
                }
                concurrentAttributes.set((AttributeKey)k, v);
            });
        }
        return concurrentAttributes;
    }

    @Override
    @Nullable
    public <T> T attr(AttributeKey<T> key) {
        Objects.requireNonNull(key, "key");
        T value = this.ownAttr0(key);
        if (value != null) {
            return value == ImmutableAttributesBuilder.NULL_VALUE ? null : (T)value;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.attr(key);
    }

    @Override
    @Nullable
    public <T> T ownAttr(AttributeKey<T> key) {
        T value = this.ownAttr0(key);
        return value == ImmutableAttributesBuilder.NULL_VALUE ? null : (T)value;
    }

    @Nullable
    private <T> T ownAttr0(AttributeKey<T> key) {
        return (T)this.attributes.get(key);
    }

    @Override
    public Iterator<Map.Entry<AttributeKey<?>, Object>> attrs() {
        if (this.parent == null) {
            return this.ownAttrs();
        }
        return new ConcatenatedIterator(this.parent.attrs(), this.ownAttrs());
    }

    @Override
    public Iterator<Map.Entry<AttributeKey<?>, Object>> ownAttrs() {
        if (this.attributes.isEmpty()) {
            return Collections.emptyIterator();
        }
        return this.attributes.entrySet().stream().filter(x -> x.getValue() != ImmutableAttributesBuilder.NULL_VALUE).iterator();
    }

    @Override
    @Nullable
    public AttributesGetters parent() {
        return this.parent;
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty() && (this.parent == null || this.parent.isEmpty());
    }

    @Override
    public int size() {
        if (this.parent == null) {
            return this.attributes.size();
        }
        return Iterators.size(this.attrs());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributesGetters)) {
            return false;
        }
        AttributesGetters that = (AttributesGetters)o;
        if (this.size() != that.size()) {
            return false;
        }
        Iterator<Map.Entry<AttributeKey<?>, Object>> it = this.attrs();
        while (it.hasNext()) {
            Object thatVal;
            Map.Entry<AttributeKey<?>, Object> next = it.next();
            Object thisVal = next.getValue();
            if (thisVal.equals(thatVal = that.attr(next.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        Iterator<Map.Entry<AttributeKey<?>, Object>> it = this.attrs();
        while (it.hasNext()) {
            Map.Entry<AttributeKey<?>, Object> next = it.next();
            hashCode += next.getKey().hashCode();
            hashCode += next.getValue().hashCode();
        }
        return hashCode;
    }

    public String toString() {
        return Iterators.toString(this.attrs());
    }

    private class ConcatenatedIterator
    implements Iterator<Map.Entry<AttributeKey<?>, Object>> {
        private final Iterator<Map.Entry<AttributeKey<?>, Object>> parentIt;
        private final Iterator<Map.Entry<AttributeKey<?>, Object>> childIt;
        @Nullable
        private Map.Entry<AttributeKey<?>, Object> next;

        ConcatenatedIterator(Iterator<Map.Entry<AttributeKey<?>, Object>> parentIt, Iterator<Map.Entry<AttributeKey<?>, Object>> childIt) {
            this.childIt = childIt;
            this.parentIt = parentIt;
            this.next = childIt.hasNext() ? childIt.next() : (parentIt.hasNext() ? parentIt.next() : null);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<AttributeKey<?>, Object> next() {
            Map.Entry<AttributeKey<?>, Object> next;
            block4: {
                next = this.next;
                if (next == null) {
                    throw new NoSuchElementException();
                }
                if (this.childIt.hasNext()) {
                    this.next = this.childIt.next();
                } else {
                    while (this.parentIt.hasNext()) {
                        Map.Entry<AttributeKey<?>, Object> tempNext = this.parentIt.next();
                        if (ImmutableAttributes.this.ownAttr0(tempNext.getKey()) != null) continue;
                        this.next = tempNext;
                        break block4;
                    }
                    this.next = null;
                }
            }
            return next;
        }
    }
}

