/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.RouteDecoratingService;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Lists;
import com.linecorp.armeria.server.CatchAllPathMapping;
import com.linecorp.armeria.server.CompositeRouter;
import com.linecorp.armeria.server.RejectedRouteHandler;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RouteBuilder;
import com.linecorp.armeria.server.RouteCache;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.Router;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingResult;
import com.linecorp.armeria.server.RoutingTrie;
import com.linecorp.armeria.server.RoutingTrieBuilder;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.VirtualHost;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Routers {
    private static final Logger logger = LoggerFactory.getLogger(Routers.class);

    static Router<ServiceConfig> ofVirtualHost(VirtualHost virtualHost, Iterable<ServiceConfig> configs, RejectedRouteHandler rejectionHandler) {
        Objects.requireNonNull(virtualHost, "virtualHost");
        Objects.requireNonNull(configs, "configs");
        Objects.requireNonNull(rejectionHandler, "rejectionHandler");
        BiConsumer<Route, Route> rejectionConsumer = (route, existingRoute) -> {
            try {
                rejectionHandler.handleDuplicateRoute(virtualHost, (Route)route, (Route)existingRoute);
            }
            catch (Exception e) {
                logger.warn("Unexpected exception from a {}:", (Object)RejectedRouteHandler.class.getSimpleName(), (Object)e);
            }
        };
        HashMap newServiceConfigs = new HashMap();
        BiFunction<Route, ServiceConfig, ServiceConfig> fallbackValueConfigurator = (originalRoute, fallbackServiceConfig) -> {
            Route fallbackRoute = fallbackServiceConfig.route();
            if (originalRoute.complexity() == fallbackRoute.complexity() && originalRoute.methods().containsAll(fallbackRoute.methods())) {
                return fallbackServiceConfig;
            }
            assert (fallbackRoute.equals(RouteBuilder.FALLBACK_ROUTE)) : "Fallback service must catch all requests, but its route is: " + fallbackRoute;
            Route newRoute = originalRoute.toBuilder().pathMapping(CatchAllPathMapping.INSTANCE).fallback(true).build();
            ServiceConfig cachedConfig = (ServiceConfig)newServiceConfigs.get(newRoute);
            if (cachedConfig != null) {
                return cachedConfig;
            }
            ServiceConfig newConfig = fallbackServiceConfig.withRoute(newRoute);
            newServiceConfigs.put(newRoute, newConfig);
            return newConfig;
        };
        Set<Route> dynamicPredicateRoutes = Routers.resolveDynamicPredicateRoutes(StreamSupport.stream(configs.spliterator(), false).map(ServiceConfig::route).collect(ImmutableList.toImmutableList()));
        return RouteCache.wrapVirtualHostRouter(Routers.defaultRouter(configs, virtualHost.fallbackServiceConfig(), fallbackValueConfigurator, ServiceConfig::route, rejectionConsumer, false), dynamicPredicateRoutes);
    }

    static Router<RouteDecoratingService> ofRouteDecoratingService(List<RouteDecoratingService> routeDecoratingServices) {
        return RouteCache.wrapRouteDecoratingServiceRouter(Routers.sequentialRouter(routeDecoratingServices, null, null, RouteDecoratingService::route, (route1, route2) -> {}, true), Routers.resolveDynamicPredicateRoutes(routeDecoratingServices.stream().map(RouteDecoratingService::route).collect(ImmutableList.toImmutableList())));
    }

    private static Set<Route> resolveDynamicPredicateRoutes(List<Route> allRoutes) {
        Set dynamicRoutes = allRoutes.stream().filter(route -> !route.isCacheable()).collect(ImmutableSet.toImmutableSet());
        Set dynamicRouteKeys = dynamicRoutes.stream().map(Routers::dynamicRouteKey).collect(ImmutableSet.toImmutableSet());
        HashSet routes = new HashSet(dynamicRoutes);
        allRoutes.forEach(route -> {
            List<Object> key = Routers.dynamicRouteKey(route);
            if (dynamicRouteKeys.contains(key)) {
                routes.add(route);
            }
        });
        return ImmutableSet.copyOf(routes);
    }

    private static List<Object> dynamicRouteKey(Route route) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add((Object)route.pathType())).addAll(route.paths())).addAll(route.methods())).addAll(route.consumes())).addAll(route.produces())).build();
    }

    private static <V> Router<V> defaultRouter(Iterable<V> values, @Nullable V fallbackValue, @Nullable BiFunction<Route, V, V> fallbackValueConfigurator, Function<V, Route> routeResolver, BiConsumer<Route, Route> rejectionHandler, boolean isRouteDecorator) {
        return new CompositeRouter(Routers.routers(values, fallbackValue, fallbackValueConfigurator, routeResolver, rejectionHandler, isRouteDecorator), Function.identity());
    }

    static <V> List<Router<V>> routers(Iterable<V> values, @Nullable V fallbackValue, @Nullable BiFunction<Route, V, V> fallbackValueConfigurator, Function<V, Route> routeResolver, BiConsumer<Route, Route> rejectionHandler, boolean isRouteDecorator) {
        Routers.rejectDuplicateMapping(values, routeResolver, rejectionHandler);
        ImmutableList.Builder builder = ImmutableList.builder();
        ArrayList<V> group = new ArrayList<V>();
        boolean addingTrie = true;
        for (V value : values) {
            Route route = routeResolver.apply(value);
            boolean hasTriePath = route.pathType().hasTriePath();
            if (addingTrie && hasTriePath || !addingTrie && !hasTriePath) {
                group.add(value);
                continue;
            }
            if (!group.isEmpty()) {
                builder.add(Routers.router(addingTrie, group, fallbackValue, fallbackValueConfigurator, routeResolver, isRouteDecorator));
            }
            addingTrie = !addingTrie;
            group.add(value);
        }
        if (!group.isEmpty()) {
            builder.add(Routers.router(addingTrie, group, fallbackValue, fallbackValueConfigurator, routeResolver, isRouteDecorator));
        }
        return builder.build();
    }

    private static <V> Router<V> sequentialRouter(Iterable<V> values, @Nullable V fallbackValue, @Nullable BiFunction<Route, V, V> fallbackValueConfigurator, Function<V, Route> routeResolver, BiConsumer<Route, Route> rejectionHandler, boolean isRouteDecorator) {
        Routers.rejectDuplicateMapping(values, routeResolver, rejectionHandler);
        return Routers.router(false, Lists.newArrayList(values), fallbackValue, fallbackValueConfigurator, routeResolver, isRouteDecorator);
    }

    private static <V> void rejectDuplicateMapping(Iterable<V> values, Function<V, Route> routeResolver, BiConsumer<Route, Route> rejectionHandler) {
        HashMap<String, List> triePath2Routes = new HashMap<String, List>();
        for (V v : values) {
            Route route = routeResolver.apply(v);
            boolean hasTriePath = route.pathType().hasTriePath();
            if (!hasTriePath) continue;
            String triePath = route.paths().get(1);
            List existingRoutes = triePath2Routes.computeIfAbsent(triePath, unused -> new ArrayList());
            for (Route existingRoute : existingRoutes) {
                if (!route.hasConflicts(existingRoute)) continue;
                rejectionHandler.accept(route, existingRoute);
                return;
            }
            existingRoutes.add(route);
        }
    }

    private static <V> Router<V> router(boolean isTrie, List<V> values, @Nullable V fallbackValue, @Nullable BiFunction<Route, V, V> fallbackValueConfigurator, Function<V, Route> routeResolver, boolean isRouteDecorator) {
        Router<V> router;
        Comparator<Object> valueComparator = Comparator.comparingInt(e -> -1 * ((Route)routeResolver.apply(e)).complexity());
        if (isTrie) {
            RoutingTrieBuilder<Object> builder = new RoutingTrieBuilder<Object>();
            builder.comparator(valueComparator);
            for (V v : values) {
                String path;
                int pathLen;
                Route route = routeResolver.apply(v);
                builder.add(route.paths().get(1), v);
                if (fallbackValue == null || (pathLen = (path = route.paths().get(0)).length()) <= 1 || path.charAt(pathLen - 1) != '/') continue;
                V newFallbackValue = fallbackValueConfigurator != null ? fallbackValueConfigurator.apply(route, fallbackValue) : fallbackValue;
                builder.add(path.substring(0, pathLen - 1), newFallbackValue, false);
            }
            router = new TrieRouter(builder.build(), routeResolver, isRouteDecorator);
        } else {
            values.sort(valueComparator);
            router = new SequentialRouter<V>(values, routeResolver, isRouteDecorator);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Router created for {} service(s): {}", (Object)values.size(), (Object)router.getClass().getSimpleName());
            for (V v : values) {
                Route route = routeResolver.apply(v);
                logger.debug("patternString: {}, complexity: {}", (Object)route.patternString(), (Object)route.complexity());
            }
        }
        values.clear();
        return router;
    }

    private static <V> Routed<V> findBest(List<Routed<V>> routes) {
        Routed<Object> result = Routed.empty();
        for (Routed<V> route : routes) {
            RoutingResult routingResult = route.routingResult();
            if (!routingResult.isPresent()) continue;
            if (routingResult.hasHighestScore()) {
                result = route;
                break;
            }
            if (result.isPresent()) {
                if (routingResult.score() <= result.routingResult().score()) continue;
                result = route;
                continue;
            }
            result = route;
        }
        return result;
    }

    private static <V> List<Routed<V>> getRouteCandidates(RoutingContext routingCtx, List<V> values, Function<V, Route> routeResolver, boolean isRouteDecorator) {
        ImmutableList.Builder builder = null;
        int remaining = values.size();
        for (V value : values) {
            Route route = routeResolver.apply(value);
            RoutingResult routingResult = route.apply(routingCtx, isRouteDecorator);
            if (routingResult.isPresent()) {
                if (builder == null) {
                    builder = ImmutableList.builderWithExpectedSize(remaining);
                }
                builder.add(Routed.of(route, routingResult, value));
            }
            --remaining;
        }
        return builder != null ? builder.build() : ImmutableList.of();
    }

    private Routers() {
    }

    private static final class TrieRouter<V>
    implements Router<V> {
        private final RoutingTrie<V> trie;
        private final Function<V, Route> routeResolver;
        private final boolean isRouteDecorator;

        TrieRouter(RoutingTrie<V> trie, Function<V, Route> routeResolver, boolean isRouteDecorator) {
            this.trie = Objects.requireNonNull(trie, "trie");
            this.routeResolver = Objects.requireNonNull(routeResolver, "routeResolver");
            this.isRouteDecorator = isRouteDecorator;
        }

        @Override
        public Routed<V> find(RoutingContext routingCtx) {
            RouteCandidateCollectingNodeProcessor processor = new RouteCandidateCollectingNodeProcessor(routingCtx);
            this.trie.find(routingCtx.path(), processor);
            return Routers.findBest(processor.collectRouteCandidates());
        }

        @Override
        public List<Routed<V>> findAll(RoutingContext routingCtx) {
            return Routers.getRouteCandidates(routingCtx, this.trie.findAll(routingCtx.path()), this.routeResolver, this.isRouteDecorator);
        }

        @Override
        public void dump(OutputStream output) {
            this.trie.dump(output);
        }

        private final class RouteCandidateCollectingNodeProcessor
        implements RoutingTrie.NodeProcessor<V> {
            private final RoutingContext routingCtx;
            @Nullable
            private ImmutableList.Builder<Routed<V>> routeCollector;

            private RouteCandidateCollectingNodeProcessor(RoutingContext routingCtx) {
                this.routingCtx = routingCtx;
            }

            @Override
            @Nullable
            public RoutingTrie.Node<V> process(RoutingTrie.Node<V> node) {
                List list = Routers.getRouteCandidates(this.routingCtx, node.values, TrieRouter.this.routeResolver, TrieRouter.this.isRouteDecorator);
                if (list.isEmpty()) {
                    return null;
                }
                if (this.routeCollector == null) {
                    this.routeCollector = ImmutableList.builder();
                }
                this.routeCollector.addAll((Iterable)list);
                return node;
            }

            List<Routed<V>> collectRouteCandidates() {
                return this.routeCollector != null ? this.routeCollector.build() : ImmutableList.of();
            }
        }
    }

    private static final class SequentialRouter<V>
    implements Router<V> {
        private final List<V> values;
        private final Function<V, Route> routeResolver;
        private final boolean isRouteDecorator;

        SequentialRouter(List<V> values, Function<V, Route> routeResolver, boolean isRouteDecorator) {
            this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values"));
            this.routeResolver = Objects.requireNonNull(routeResolver, "routeResolver");
            this.isRouteDecorator = isRouteDecorator;
        }

        @Override
        public Routed<V> find(RoutingContext routingCtx) {
            return Routers.findBest(Routers.getRouteCandidates(routingCtx, this.values, this.routeResolver, false));
        }

        @Override
        public List<Routed<V>> findAll(RoutingContext routingCtx) {
            return Routers.getRouteCandidates(routingCtx, this.values, this.routeResolver, this.isRouteDecorator);
        }

        @Override
        public void dump(OutputStream output) {
            PrintWriter p = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
            p.printf("Dump of %s:%n", this);
            for (int i = 0; i < this.values.size(); ++i) {
                p.printf("<%d> %s%n", i, this.values.get(i));
            }
            p.flush();
        }
    }
}

