/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.config.ConfigReader;
import org.apache.baremaps.maplibre.style.Style;
import org.apache.baremaps.maplibre.tileset.Tileset;
import org.apache.baremaps.maplibre.tileset.TilesetQuery;
import org.apache.baremaps.openstreetmap.stream.ProgressLogger;
import org.apache.baremaps.openstreetmap.stream.StreamUtils;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileEntry;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.apache.baremaps.tilestore.file.FileTileStore;
import org.apache.baremaps.tilestore.mbtiles.MBTilesStore;
import org.apache.baremaps.tilestore.pmtiles.PMTilesStore;
import org.apache.baremaps.tilestore.postgres.PostgresTileStore;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.apache.baremaps.utils.SqliteUtils;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportVectorTiles
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ExportVectorTiles.class);
    private Path tileset;
    private Path style;
    private Path repository;
    private Format format;

    public ExportVectorTiles() {
    }

    public ExportVectorTiles(Path tileset, Path style, Path repository, Format format) {
        this.tileset = tileset;
        this.style = style;
        this.repository = repository;
        this.format = format;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        ConfigReader configReader = new ConfigReader();
        ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
        Tileset tilesetObject = (Tileset)objectMapper.readValue(configReader.read(this.tileset), Tileset.class);
        Style styleObject = (Style)objectMapper.readValue(configReader.read(this.style), Style.class);
        Path directory = switch (this.format) {
            default -> throw new IncompatibleClassChangeError();
            case Format.FILE -> this.repository;
            case Format.MBTILES -> this.repository.getParent();
            case Format.PMTILES -> this.repository.getParent();
        };
        Files.createDirectories(directory, new FileAttribute[0]);
        try (InputStream html = this.getClass().getResourceAsStream("/static/server.html");){
            Files.write(directory.resolve("index.html"), html.readAllBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        Files.write(directory.resolve("tiles.json"), objectMapper.writeValueAsBytes((Object)tilesetObject), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        Files.write(directory.resolve("style.json"), objectMapper.writeValueAsBytes((Object)styleObject), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        DataSource datasource = context.getDataSource(tilesetObject.getDatabase());
        try (TileStore sourceTileStore = this.sourceTileStore(tilesetObject, datasource);
             TileStore targetTileStore = this.targetTileStore(tilesetObject);){
            Envelope envelope = tilesetObject.getBounds().size() == 4 ? new Envelope(((Double)tilesetObject.getBounds().get(0)).doubleValue(), ((Double)tilesetObject.getBounds().get(2)).doubleValue(), ((Double)tilesetObject.getBounds().get(1)).doubleValue(), ((Double)tilesetObject.getBounds().get(3)).doubleValue()) : new Envelope(-180.0, 180.0, -85.0511, 85.0511);
            long count = TileCoord.count(envelope, tilesetObject.getMinzoom(), tilesetObject.getMaxzoom());
            long start = System.currentTimeMillis();
            Iterator<TileCoord> tileCoordIterator = TileCoord.iterator(envelope, tilesetObject.getMinzoom(), tilesetObject.getMaxzoom());
            Stream tileCoordStream = StreamUtils.stream(tileCoordIterator).peek(new ProgressLogger(Long.valueOf(count), Integer.valueOf(5000)));
            Stream bufferedTileEntryStream = StreamUtils.bufferInCompletionOrder(tileCoordStream, tile -> {
                try {
                    return new TileEntry((TileCoord)tile, sourceTileStore.read((TileCoord)tile));
                }
                catch (TileStoreException e) {
                    throw new WorkflowException(e);
                }
            }, (int)1000);
            Stream partitionedTileEntryStream = StreamUtils.partition((Stream)bufferedTileEntryStream, (int)1000);
            partitionedTileEntryStream.forEach(batch -> {
                try {
                    targetTileStore.write(batch);
                }
                catch (TileStoreException e) {
                    throw new WorkflowException(e);
                }
            });
            long stop = System.currentTimeMillis();
            logger.info("Exported {} tiles in {}s", (Object)count, (Object)((stop - start) / 1000L));
        }
    }

    private TileStore sourceTileStore(Tileset tileset, DataSource datasource) {
        return new PostgresTileStore(datasource, tileset);
    }

    private TileStore targetTileStore(Tileset source) throws TileStoreException, IOException {
        switch (this.format) {
            case FILE: {
                return new FileTileStore(this.repository.resolve("tiles"));
            }
            case MBTILES: {
                Files.deleteIfExists(this.repository);
                DataSource dataSource = SqliteUtils.createDataSource(this.repository, false);
                MBTilesStore tilesStore = new MBTilesStore(dataSource);
                tilesStore.initializeDatabase();
                tilesStore.writeMetadata(this.metadata(source));
                return tilesStore;
            }
            case PMTILES: {
                Files.deleteIfExists(this.repository);
                return new PMTilesStore(this.repository, source);
            }
        }
        throw new IllegalArgumentException("Unsupported format");
    }

    private Map<String, String> metadata(Tileset tileset) throws JsonProcessingException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("name", tileset.getName());
        metadata.put("version", tileset.getVersion());
        metadata.put("description", tileset.getDescription());
        metadata.put("attribution", tileset.getAttribution());
        metadata.put("type", "baselayer");
        metadata.put("format", "pbf");
        metadata.put("center", tileset.getCenter().stream().map(Object::toString).collect(Collectors.joining(", ")));
        metadata.put("bounds", tileset.getBounds().stream().map(Object::toString).collect(Collectors.joining(", ")));
        metadata.put("minzoom", Double.toString(tileset.getMinzoom().intValue()));
        metadata.put("maxzoom", Double.toString(tileset.getMaxzoom().intValue()));
        List<Map> layers = tileset.getVectorLayers().stream().map(layer -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", layer.getId());
            map.put("description", layer.getDescription());
            map.put("minzoom", layer.getQueries().stream().mapToInt(TilesetQuery::getMinzoom).min().getAsInt());
            map.put("maxzoom", layer.getQueries().stream().mapToInt(TilesetQuery::getMaxzoom).max().getAsInt());
            return map;
        }).toList();
        metadata.put("json", new ObjectMapper().writeValueAsString(layers));
        return metadata;
    }

    public String toString() {
        return new StringJoiner(", ", ExportVectorTiles.class.getSimpleName() + "[", "]").add("tileset=" + this.tileset).add("repository=" + this.repository).add("format=" + this.format).toString();
    }

    public static enum Format {
        FILE,
        MBTILES,
        PMTILES;

    }
}

