/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.raster;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.Weigher;
import java.awt.image.BufferedImage;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.checkerframework.checker.index.qual.NonNegative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterTileCache
implements TileStore<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(RasterTileCache.class);
    private final TileStore<BufferedImage> tileStore;
    private final Cache<TileCoord, BufferedImage> cache;

    public RasterTileCache(TileStore<BufferedImage> tileStore, CaffeineSpec caffeineSpec) {
        this.tileStore = tileStore;
        this.cache = Caffeine.from((CaffeineSpec)caffeineSpec).weigher((Weigher)new Weigher<TileCoord, BufferedImage>(){

            public @NonNegative int weigh(TileCoord tileCoord, BufferedImage bufferedImage) {
                return bufferedImage.getData().getDataBuffer().getSize() * 4;
            }
        }).build();
    }

    @Override
    public BufferedImage read(TileCoord tileCoord) throws TileStoreException {
        return (BufferedImage)this.cache.get((Object)tileCoord, t -> {
            try {
                return this.tileStore.read((TileCoord)t);
            }
            catch (TileStoreException e) {
                logger.error("Unable to read the tile.", (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public void write(TileCoord tileCoord, BufferedImage bufferedImage) throws TileStoreException {
        this.tileStore.write(tileCoord, bufferedImage);
        this.cache.invalidate((Object)tileCoord);
    }

    @Override
    public void delete(TileCoord tileCoord) throws TileStoreException {
        this.tileStore.delete(tileCoord);
        this.cache.invalidate((Object)tileCoord);
    }

    @Override
    public void close() throws Exception {
        this.cache.cleanUp();
        this.tileStore.close();
    }
}

