/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.geotiff.GeoKeys;
import org.apache.sis.storage.geotiff.GeoKeysLoader;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.Tags;
import org.apache.sis.storage.geotiff.Type;
import org.apache.sis.storage.geotiff.XMLMetadata;
import org.apache.sis.storage.geotiff.internal.Compression;
import org.apache.sis.storage.geotiff.internal.Predictor;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Vocabulary;

final class NativeMetadata
extends GeoKeysLoader {
    private static final TableColumn<Integer> CODE = new TableColumn(Integer.class, (CharSequence)Vocabulary.formatInternational((short)28));
    static final TableColumn<CharSequence> NAME = TableColumn.NAME;
    static final TableColumn<Object> VALUE = TableColumn.VALUE;
    private ChannelDataInput input;
    private boolean isClassic;
    private TreeTable.Node geoNode;
    private final Vocabulary vocabulary;

    NativeMetadata(Locale locale) {
        this.vocabulary = Vocabulary.getResources((Locale)locale);
    }

    final DefaultTreeTable read(Reader reader) throws IOException {
        this.input = reader.input;
        this.isClassic = reader.intSizeExpansion == 0;
        int offsetSize = 4 << reader.intSizeExpansion;
        DefaultTreeTable table = new DefaultTreeTable(new TableColumn[]{CODE, NAME, VALUE});
        TreeTable.Node root = table.getRoot();
        root.setValue(NAME, (Object)"TIFF");
        this.input.mark();
        try {
            long nextIFD;
            this.input.seek(Math.addExact(reader.origin, this.isClassic ? 4L : 8L));
            HashSet<Long> doneIFD = new HashSet<Long>();
            int imageNumber = 0;
            while ((nextIFD = this.readInt(false)) != 0L) {
                if (!doneIFD.add(nextIFD)) {
                    break;
                }
                TreeTable.Node image = root.newChild();
                image.setValue(NAME, (Object)this.vocabulary.getString((short)261, (Object)imageNumber));
                this.input.seek(Math.addExact(reader.origin, nextIFD));
                long remaining = this.readInt(true);
                while (--remaining >= 0L) {
                    boolean visible;
                    short tag = (short)this.input.readUnsignedShort();
                    Type type = Type.valueOf(this.input.readShort());
                    long count = this.readInt(false);
                    long size = type != null ? Math.multiplyExact((long)type.size, count) : 0L;
                    long next = Math.addExact(this.input.getStreamPosition(), (long)offsetSize);
                    switch (tag) {
                        case 273: 
                        case 279: 
                        case 324: 
                        case 325: {
                            visible = false;
                            break;
                        }
                        default: {
                            boolean bl = visible = size != 0L;
                        }
                    }
                    if (visible) {
                        if (size > (long)offsetSize) {
                            long offset = this.readInt(false);
                            this.input.seek(Math.addExact(reader.origin, offset));
                        }
                        Object value = null;
                        XMLMetadata children = null;
                        block5 : switch (tag) {
                            case -30801: {
                                this.writeGeoKeys();
                                this.keyDirectory = type.readAsVector(this.input, count);
                                value = "GeoTIFF";
                                break;
                            }
                            case -30800: {
                                this.numericParameters = type.readAsVector(this.input, count);
                                visible = false;
                                break;
                            }
                            case -30799: {
                                this.setAsciiParameters(type.readAsStrings(this.input, count, reader.store.encoding));
                                visible = false;
                                break;
                            }
                            case -23424: 
                            case -14627: {
                                children = new XMLMetadata(reader, type, count, tag);
                                if (!children.isEmpty()) break;
                                value = type.readAsVector(this.input, count);
                                break;
                            }
                            default: {
                                value = type.readAsObject(this.input, count);
                                if (value instanceof Vector) {
                                    Vector v = (Vector)value;
                                    switch (v.size()) {
                                        case 0: {
                                            value = null;
                                            break;
                                        }
                                        case 1: {
                                            value = v.get(0);
                                        }
                                    }
                                }
                                switch (tag) {
                                    case 259: {
                                        value = NativeMetadata.toString(value, Compression::valueOf, Compression.UNKNOWN);
                                        break block5;
                                    }
                                    case 317: {
                                        value = NativeMetadata.toString(value, Predictor::valueOf, Predictor.UNKNOWN);
                                    }
                                }
                            }
                        }
                        if (visible) {
                            Object node;
                            String name = Tags.name(tag);
                            if (children != null) {
                                node = new XMLMetadata.Root(children, (DefaultTreeTable.Node)image, name);
                            } else {
                                node = image.newChild();
                                node.setValue(NAME, (Object)name);
                                node.setValue(VALUE, value);
                            }
                            node.setValue(CODE, (Object)Short.toUnsignedInt(tag));
                            if (tag == -30801) {
                                this.geoNode = node;
                            }
                        }
                    }
                    this.input.seek(next);
                }
                ++imageNumber;
            }
        }
        catch (ArithmeticException e) {
            throw new IOException(e);
        }
        finally {
            this.input.reset();
        }
        this.writeGeoKeys();
        return table;
    }

    private long readInt(boolean isShort) throws IOException {
        if (this.isClassic) {
            return isShort ? (long)this.input.readUnsignedShort() : this.input.readUnsignedInt();
        }
        long entry = this.input.readLong();
        if (entry < 0L) {
            throw new ArithmeticException();
        }
        return entry;
    }

    private static Object toString(Object value, IntFunction<Enum<?>> valueOf, Enum<?> unknown) {
        Enum<?> c;
        if (value != null && Numbers.isInteger(value.getClass()) && (c = valueOf.apply(((Number)value).intValue())) != unknown) {
            return c.name();
        }
        return value;
    }

    private void writeGeoKeys() {
        if (this.geoNode != null) {
            LinkedHashMap<Short, Object> geoKeys = new LinkedHashMap<Short, Object>(32);
            this.load(geoKeys);
            for (Map.Entry entry : geoKeys.entrySet()) {
                TreeTable.Node node = this.geoNode.newChild();
                short code = (Short)entry.getKey();
                node.setValue(CODE, (Object)Short.toUnsignedInt(code));
                node.setValue(NAME, (Object)GeoKeys.name(code));
                node.setValue(VALUE, entry.getValue());
            }
            this.geoNode = null;
        }
    }
}

