/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.internal;

import java.util.Collection;
import java.util.Locale;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Static;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Identifiers
extends Static {
    private Identifiers() {
    }

    public static boolean isEPSG(String codeSpace, String code) {
        return "EPSG".equalsIgnoreCase(code) && ("IOGP".equalsIgnoreCase(codeSpace) || "OGP".equalsIgnoreCase(codeSpace) || "EPSG".equalsIgnoreCase(codeSpace));
    }

    private static boolean isDeprecated(Object object) {
        return object instanceof Deprecable && ((Deprecable)object).isDeprecated();
    }

    private static String trimOrNull(InternationalString title) {
        return title != null && !Identifiers.isDeprecated(title) ? Strings.trimOrNull((String)title.toString(Locale.ROOT)) : null;
    }

    public static String getIdentifier(Citation citation, boolean strict) {
        if (citation != null) {
            String candidate;
            boolean isUnicode = false;
            String identifier = null;
            String codeSpace = null;
            for (Identifier id : CollectionsExt.nonNull((Collection)citation.getIdentifiers())) {
                if (id == null || Identifiers.isDeprecated(id) || (candidate = Strings.trimOrNull((String)id.getCode())) == null) continue;
                String cs = null;
                if (id instanceof ReferenceIdentifier) {
                    cs = Strings.trimOrNull((String)((ReferenceIdentifier)id).getCodeSpace());
                }
                if (cs == null || cs.isEmpty()) {
                    cs = null;
                    isUnicode = CharSequences.isUnicodeIdentifier((CharSequence)candidate);
                } else {
                    isUnicode = CharSequences.isUnicodeIdentifier((CharSequence)cs);
                    if (isUnicode) {
                        int c;
                        for (int i = 0; i < candidate.length(); i += Character.charCount(c)) {
                            c = candidate.codePointAt(i);
                            if (Character.isUnicodeIdentifierPart(c) || !strict && (c == 46 || c == 45)) continue;
                            isUnicode = false;
                            break;
                        }
                    }
                }
                if (identifier != null && !isUnicode) continue;
                identifier = candidate;
                codeSpace = cs;
                if (!isUnicode) continue;
                break;
            }
            if (identifier == null) {
                identifier = Identifiers.trimOrNull(citation.getTitle());
                if (identifier != null) {
                    isUnicode = CharSequences.isUnicodeIdentifier((CharSequence)identifier);
                }
                if (!isUnicode) {
                    for (InternationalString i18n : CollectionsExt.nonNull((Collection)citation.getAlternateTitles())) {
                        candidate = Identifiers.trimOrNull(i18n);
                        if (candidate == null) continue;
                        isUnicode = CharSequences.isUnicodeIdentifier((CharSequence)candidate);
                        if (identifier != null && !isUnicode) continue;
                        identifier = candidate;
                        if (!isUnicode) continue;
                        break;
                    }
                }
            }
            if (isUnicode || !strict) {
                if (codeSpace != null && !Identifiers.isEPSG(codeSpace, identifier)) {
                    return codeSpace + (strict ? (char)'_' : ':') + identifier;
                }
                return identifier;
            }
        }
        return null;
    }

    private static boolean authorityMatches(Identifier identifier, Citation authority, String codeSpace) {
        Object other;
        if (authority != null && (other = identifier.getAuthority()) != null) {
            return Citations.identifierMatches(authority, other);
        }
        if (codeSpace != null && identifier instanceof ReferenceIdentifier && (other = ((ReferenceIdentifier)identifier).getCodeSpace()) != null) {
            return CharSequences.equalsFiltered((CharSequence)codeSpace, (CharSequence)other, (Characters.Filter)Characters.Filter.UNICODE_IDENTIFIER, (boolean)true);
        }
        return false;
    }

    public static Boolean hasCommonIdentifier(Iterable<? extends ReferenceIdentifier> id1, Iterable<? extends ReferenceIdentifier> id2) {
        if (id1 != null && id2 != null) {
            boolean hasFound = false;
            for (ReferenceIdentifier referenceIdentifier : id1) {
                Citation authority = referenceIdentifier.getAuthority();
                String codeSpace = referenceIdentifier.getCodeSpace();
                for (Identifier identifier : id2) {
                    if (!Identifiers.authorityMatches((Identifier)referenceIdentifier, authority, codeSpace)) continue;
                    if (CharSequences.equalsFiltered((CharSequence)referenceIdentifier.getCode(), (CharSequence)identifier.getCode(), (Characters.Filter)Characters.Filter.UNICODE_IDENTIFIER, (boolean)true)) {
                        return Boolean.TRUE;
                    }
                    hasFound = true;
                }
            }
            if (hasFound) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static String missingValueForProperty(Identifier owner, String property) {
        return owner == null ? Errors.format((short)89, (Object)property) : Errors.format((short)197, (Object)owner, (Object)property);
    }
}

