/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.metadata.replace;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Map;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.internal.ReferencingServices;
import org.apache.sis.metadata.iso.quality.DefaultMeasureDescription;
import org.apache.sis.util.Classes;
import org.apache.sis.util.iso.Names;
import org.apache.sis.xml.bind.gco.GO_GenericName;
import org.apache.sis.xml.bind.metadata.replace.Parameter;
import org.apache.sis.xml.bind.metadata.replace.RS_Identifier;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.InternationalString;
import org.opengis.util.TypeName;

@XmlType(name="DQM_Parameter_Type", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0", propOrder={"code", "definition", "description", "valueType"})
@XmlRootElement(name="DQM_Parameter", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0")
public final class QualityParameter
extends Parameter {
    private static final long serialVersionUID = 4333632866772665659L;
    @XmlElement(name="name", required=true)
    public String code;
    @XmlElement(required=true)
    public InternationalString definition;
    @XmlElement
    public DefaultMeasureDescription description;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=GO_GenericName.class)
    public TypeName valueType;

    public QualityParameter() {
    }

    private QualityParameter(ParameterDescriptor<?> parameter) {
        super(parameter);
        ReferenceIdentifier id = parameter.getName();
        if (id != null) {
            this.code = id.getCode();
        }
        this.valueType = ReferencingServices.getInstance().getValueType(parameter);
    }

    public static QualityParameter castOrCopy(ParameterDescriptor<?> parameter) {
        if (parameter == null || parameter instanceof QualityParameter) {
            return (QualityParameter)parameter;
        }
        return new QualityParameter(parameter);
    }

    public int getMinimumOccurs() {
        return 0;
    }

    public int getMaximumOccurs() {
        return 1;
    }

    @Override
    public synchronized ReferenceIdentifier getName() {
        if (this.name == null && this.code != null) {
            RS_Identifier id = new RS_Identifier(null, this.code, null);
            id.setDescription(this.definition);
            id.transitionTo(ModifiableMetadata.State.FINAL);
            this.name = id;
        }
        return this.name;
    }

    public Class<?> getValueClass() {
        Class<Object> type = super.getValueClass();
        if (type == null) {
            type = Names.toClass(this.valueType);
        }
        return type;
    }

    @Override
    public TypeName getValueType() {
        return this.valueType;
    }

    public static TypeName getValueType(Class<?> valueClass) {
        if (valueClass.isArray()) {
            valueClass = valueClass.getComponentType();
        } else if (Iterable.class.isAssignableFrom(valueClass) || Map.class.isAssignableFrom(valueClass)) {
            valueClass = Classes.boundOfParameterizedDeclaration(valueClass);
        } else if (Matrix.class.isAssignableFrom(valueClass)) {
            valueClass = Double.class;
        }
        return Names.createTypeName(valueClass);
    }
}

