/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.jts;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.distance.CartesianDistCalc;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.BaseShape;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.BBoxCalculator;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;
import org.locationtech.spatial4j.shape.jts.JtsPoint;

public class JtsGeometry
extends BaseShape<JtsSpatialContext> {
    public static final String SYSPROP_ASSERT_VALIDATE = "spatial4j.JtsGeometry.assertValidate";
    private final Geometry geom;
    private final boolean hasArea;
    private final Rectangle bbox;
    protected PreparedGeometry preparedGeometry;
    protected boolean validated = false;

    public JtsGeometry(Geometry geom, JtsSpatialContext ctx, boolean dateline180Check, boolean allowMultiOverlap) {
        super(ctx);
        if (geom.getClass().equals(GeometryCollection.class) && (geom = this.narrowCollectionIfPossible((GeometryCollection)geom)) == null) {
            throw new IllegalArgumentException("JtsGeometry does not support GeometryCollection but does support its subclasses.");
        }
        if (geom.isEmpty()) {
            this.bbox = new RectangleImpl(Double.NaN, Double.NaN, Double.NaN, Double.NaN, this.ctx);
        } else if (ctx.isGeo()) {
            if (dateline180Check) {
                geom = JtsGeometry.unwrapDateline(geom);
            }
            if (allowMultiOverlap) {
                geom = JtsGeometry.unionGeometryCollection(geom);
            }
            geom = JtsGeometry.cutUnwrappedGeomInto360(geom);
            assert (geom.getEnvelopeInternal().getWidth() <= 360.0);
            assert (!geom.getClass().equals(GeometryCollection.class)) : "GeometryCollection unsupported";
            this.bbox = this.computeGeoBBox(geom);
        } else {
            if (allowMultiOverlap) {
                geom = JtsGeometry.unionGeometryCollection(geom);
            }
            Envelope env = geom.getEnvelopeInternal();
            this.bbox = new RectangleImpl(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), ctx);
        }
        geom.getEnvelopeInternal();
        this.geom = geom;
        assert (this.assertValidate());
        this.hasArea = !(geom instanceof Lineal) && !(geom instanceof Puntal);
    }

    private Geometry narrowCollectionIfPossible(GeometryCollection gc) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            geoms.add(gc.getGeometryN(i));
        }
        Geometry result = gc.getFactory().buildGeometry(geoms);
        return !result.getClass().equals(GeometryCollection.class) ? result : null;
    }

    private boolean assertValidate() {
        String assertValidate = System.getProperty(SYSPROP_ASSERT_VALIDATE);
        if (assertValidate == null || Boolean.parseBoolean(assertValidate)) {
            this.validate();
        }
        return true;
    }

    public void validate() throws InvalidShapeException {
        if (!this.validated) {
            IsValidOp isValidOp = new IsValidOp(this.geom);
            if (!isValidOp.isValid()) {
                throw new InvalidShapeException(isValidOp.getValidationError().toString());
            }
            this.validated = true;
        }
    }

    boolean isIndexed() {
        return this.preparedGeometry != null;
    }

    public void index() {
        if (this.preparedGeometry == null) {
            this.preparedGeometry = PreparedGeometryFactory.prepare((Geometry)this.geom);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.bbox.isEmpty();
    }

    protected Rectangle computeGeoBBox(Geometry geoms) {
        Envelope env = geoms.getEnvelopeInternal();
        if (((JtsSpatialContext)this.ctx).isGeo() && env.getWidth() > 180.0 && geoms.getNumGeometries() > 1) {
            BBoxCalculator bboxCalc = new BBoxCalculator(this.ctx);
            for (int i = 0; i < geoms.getNumGeometries(); ++i) {
                Envelope envI = geoms.getGeometryN(i).getEnvelopeInternal();
                bboxCalc.expandXRange(envI.getMinX(), envI.getMaxX());
                if (bboxCalc.doesXWorldWrap()) break;
            }
            return new RectangleImpl(bboxCalc.getMinX(), bboxCalc.getMaxX(), env.getMinY(), env.getMaxY(), this.ctx);
        }
        return new RectangleImpl(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), this.ctx);
    }

    @Override
    public JtsGeometry getBuffered(double distance, SpatialContext ctx) {
        return ((JtsSpatialContext)this.ctx).makeShape(this.geom.buffer(distance), true, true);
    }

    @Override
    public boolean hasArea() {
        return this.hasArea;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        double geomArea = this.geom.getArea();
        if (ctx == null || geomArea == 0.0) {
            return geomArea;
        }
        double bboxArea = this.getBoundingBox().getArea(null);
        assert (bboxArea >= geomArea);
        double filledRatio = geomArea / bboxArea;
        return this.getBoundingBox().getArea(ctx) * filledRatio;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.bbox;
    }

    @Override
    public JtsPoint getCenter() {
        if (this.isEmpty()) {
            return new JtsPoint(((JtsSpatialContext)this.ctx).getGeometryFactory().createPoint((Coordinate)null), (JtsSpatialContext)this.ctx);
        }
        return new JtsPoint(this.geom.getCentroid(), (JtsSpatialContext)this.ctx);
    }

    @Override
    public SpatialRelation relate(Shape other) {
        if (other instanceof Point) {
            return this.relate((Point)other);
        }
        if (other instanceof Rectangle) {
            return this.relate((Rectangle)other);
        }
        if (other instanceof Circle) {
            return this.relate((Circle)other);
        }
        if (other instanceof JtsGeometry) {
            return this.relate((JtsGeometry)other);
        }
        if (other instanceof BufferedLineString) {
            throw new UnsupportedOperationException("Can't use BufferedLineString with JtsGeometry");
        }
        return other.relate(this).transpose();
    }

    public SpatialRelation relate(Point pt) {
        if (!this.getBoundingBox().relate(pt).intersects()) {
            return SpatialRelation.DISJOINT;
        }
        org.locationtech.jts.geom.Point ptGeom = pt instanceof JtsPoint ? ((JtsPoint)pt).getGeom() : ((JtsSpatialContext)this.ctx).getGeometryFactory().createPoint(new Coordinate(pt.getX(), pt.getY()));
        return this.relate((Geometry)ptGeom);
    }

    public SpatialRelation relate(Rectangle rectangle) {
        SpatialRelation bboxR = this.bbox.relate(rectangle);
        if (bboxR == SpatialRelation.WITHIN || bboxR == SpatialRelation.DISJOINT) {
            return bboxR;
        }
        return this.relate(((JtsSpatialContext)this.ctx).getGeometryFrom(rectangle));
    }

    public SpatialRelation relate(final Circle circle) {
        SpatialRelation bboxR = this.bbox.relate(circle);
        if (bboxR == SpatialRelation.WITHIN || bboxR == SpatialRelation.DISJOINT) {
            return bboxR;
        }
        final SpatialRelation[] result = new SpatialRelation[]{null};
        this.geom.apply(new GeometryFilter(){
            final CartesianDistCalc calcSqd = CartesianDistCalc.INSTANCE_SQUARED;
            final double radiusSquared = circle.getRadius() * circle.getRadius();
            final Geometry ctrGeom = ((JtsSpatialContext)JtsGeometry.access$000(JtsGeometry.this)).getGeometryFrom(circle.getCenter());

            public void filter(Geometry geom) {
                if (result[0] == SpatialRelation.INTERSECTS || result[0] == SpatialRelation.CONTAINS) {
                    return;
                }
                if (geom instanceof Polygon) {
                    Polygon polygon = (Polygon)geom;
                    SpatialRelation rel = this.relateEnclosedRing(polygon.getExteriorRing());
                    if (rel == SpatialRelation.CONTAINS) {
                        block4: for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                            switch (this.relateEnclosedRing(polygon.getInteriorRingN(i))) {
                                case WITHIN: 
                                case INTERSECTS: {
                                    rel = SpatialRelation.INTERSECTS;
                                    break block4;
                                }
                                case CONTAINS: {
                                    rel = SpatialRelation.DISJOINT;
                                    break block4;
                                }
                                default: {
                                    continue block4;
                                }
                            }
                        }
                    }
                    result[0] = rel.combine(result[0]);
                } else if (geom instanceof LineString) {
                    LineString lineString = (LineString)geom;
                    SpatialRelation rel = this.relateLineString(lineString);
                    result[0] = rel.combine(result[0]);
                } else if (geom instanceof org.locationtech.jts.geom.Point) {
                    org.locationtech.jts.geom.Point point = (org.locationtech.jts.geom.Point)geom;
                    SpatialRelation rel = this.calcSqd.distance(circle.getCenter(), point.getX(), point.getY()) > this.radiusSquared ? SpatialRelation.DISJOINT : SpatialRelation.WITHIN;
                    result[0] = rel.combine(result[0]);
                }
            }

            SpatialRelation relateEnclosedRing(LinearRing ring) {
                SpatialRelation rel = this.relateLineString((LineString)ring);
                if (rel == SpatialRelation.DISJOINT && ((JtsSpatialContext)JtsGeometry.this.ctx).getGeometryFactory().createPolygon(ring, null).contains(this.ctrGeom)) {
                    rel = SpatialRelation.CONTAINS;
                }
                return rel;
            }

            SpatialRelation relateLineString(LineString lineString) {
                int i;
                CoordinateSequence seq = lineString.getCoordinateSequence();
                boolean isRing = lineString instanceof LinearRing;
                int numOutside = 0;
                int numComparisons = 0;
                for (i = 0; i < seq.size(); ++i) {
                    boolean outside;
                    if (i == 0 && isRing) continue;
                    ++numComparisons;
                    boolean bl = outside = this.calcSqd.distance(circle.getCenter(), seq.getX(i), seq.getY(i)) > this.radiusSquared;
                    if (outside) {
                        ++numOutside;
                    }
                    if (numComparisons == numOutside || numOutside == 0) continue;
                    assert (numComparisons > 1);
                    return SpatialRelation.INTERSECTS;
                }
                if (numOutside == 0) {
                    return SpatialRelation.WITHIN.combine(result[0]);
                }
                for (i = 1; i < seq.size(); ++i) {
                    boolean outside;
                    boolean bl = outside = this.calcSqd.distanceToLineSegment(circle.getCenter(), seq.getX(i - 1), seq.getY(i - 1), seq.getX(i), seq.getY(i)) > this.radiusSquared;
                    if (outside) continue;
                    return SpatialRelation.INTERSECTS;
                }
                return SpatialRelation.DISJOINT;
            }
        });
        return result[0] == null ? SpatialRelation.DISJOINT : result[0];
    }

    public SpatialRelation relate(JtsGeometry jtsGeometry) {
        return this.relate(jtsGeometry.geom);
    }

    protected SpatialRelation relate(Geometry oGeom) {
        if (oGeom instanceof org.locationtech.jts.geom.Point) {
            if (this.preparedGeometry != null) {
                return this.preparedGeometry.disjoint(oGeom) ? SpatialRelation.DISJOINT : SpatialRelation.CONTAINS;
            }
            return this.geom.disjoint(oGeom) ? SpatialRelation.DISJOINT : SpatialRelation.CONTAINS;
        }
        if (this.preparedGeometry == null) {
            return JtsGeometry.intersectionMatrixToSpatialRelation(this.geom.relate(oGeom));
        }
        if (this.preparedGeometry.covers(oGeom)) {
            return SpatialRelation.CONTAINS;
        }
        if (this.preparedGeometry.coveredBy(oGeom)) {
            return SpatialRelation.WITHIN;
        }
        if (this.preparedGeometry.intersects(oGeom)) {
            return SpatialRelation.INTERSECTS;
        }
        return SpatialRelation.DISJOINT;
    }

    public static SpatialRelation intersectionMatrixToSpatialRelation(IntersectionMatrix matrix) {
        if (matrix.isCovers()) {
            return SpatialRelation.CONTAINS;
        }
        if (matrix.isCoveredBy()) {
            return SpatialRelation.WITHIN;
        }
        if (matrix.isDisjoint()) {
            return SpatialRelation.DISJOINT;
        }
        return SpatialRelation.INTERSECTS;
    }

    public String toString() {
        return this.geom.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JtsGeometry that = (JtsGeometry)o;
        return this.geom.equalsExact(that.geom);
    }

    public int hashCode() {
        return this.geom.getEnvelopeInternal().hashCode();
    }

    public Geometry getGeom() {
        return this.geom;
    }

    private static Geometry unwrapDateline(Geometry geom) {
        if (geom.getEnvelopeInternal().getWidth() < 180.0) {
            return geom;
        }
        if (geom instanceof GeometryCollection) {
            if (geom instanceof MultiPoint) {
                return geom;
            }
            GeometryCollection gc = (GeometryCollection)geom;
            ArrayList<Geometry> list = new ArrayList<Geometry>(gc.getNumGeometries());
            boolean didUnwrap = false;
            for (int n = 0; n < gc.getNumGeometries(); ++n) {
                Geometry geometryN = gc.getGeometryN(n);
                Geometry geometryUnwrapped = JtsGeometry.unwrapDateline(geometryN);
                list.add(geometryUnwrapped);
                didUnwrap |= geometryUnwrapped != geometryN;
            }
            return !didUnwrap ? geom : geom.getFactory().buildGeometry(list);
        }
        Geometry newGeom = geom.copy();
        final int[] crossings = new int[]{0};
        newGeom.apply(new GeometryFilter(){

            public void filter(Geometry geom) {
                int cross;
                if (geom instanceof LineString) {
                    if (geom.getEnvelopeInternal().getWidth() < 180.0) {
                        return;
                    }
                    cross = JtsGeometry.unwrapDateline((LineString)geom);
                } else if (geom instanceof Polygon) {
                    if (geom.getEnvelopeInternal().getWidth() < 180.0) {
                        return;
                    }
                    cross = JtsGeometry.unwrapDateline((Polygon)geom);
                } else {
                    return;
                }
                crossings[0] = Math.max(crossings[0], cross);
            }
        });
        if (crossings[0] > 0) {
            newGeom.geometryChanged();
            return newGeom;
        }
        return geom;
    }

    private static int unwrapDateline(Polygon poly) {
        LinearRing exteriorRing = poly.getExteriorRing();
        int cross = JtsGeometry.unwrapDateline((LineString)exteriorRing);
        if (cross > 0) {
            for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                LinearRing innerLineString = poly.getInteriorRingN(i);
                JtsGeometry.unwrapDateline((LineString)innerLineString);
                int shiftCount = 0;
                while (!exteriorRing.contains((Geometry)innerLineString)) {
                    if (shiftCount > cross) {
                        throw new IllegalArgumentException("The inner ring doesn't appear to be within the exterior: " + exteriorRing + " inner: " + innerLineString);
                    }
                    JtsGeometry.shiftGeomByX((Geometry)innerLineString, 360);
                    ++shiftCount;
                }
            }
        }
        return cross;
    }

    private static int unwrapDateline(LineString lineString) {
        CoordinateSequence cseq = lineString.getCoordinateSequence();
        int size = cseq.size();
        if (size <= 1) {
            return 0;
        }
        int shiftX = 0;
        int shiftXPage = 0;
        int shiftXPageMin = 0;
        int shiftXPageMax = 0;
        double prevX = cseq.getX(0);
        for (int i = 1; i < size; ++i) {
            double thisX_orig = cseq.getX(i);
            assert (thisX_orig >= -180.0 && thisX_orig <= 180.0) : "X not in geo bounds";
            double thisX = thisX_orig + (double)shiftX;
            if (prevX - thisX > 180.0) {
                thisX += 360.0;
                shiftX += 360;
                shiftXPageMax = Math.max(shiftXPageMax, ++shiftXPage);
            } else if (thisX - prevX > 180.0) {
                thisX -= 360.0;
                shiftX -= 360;
                shiftXPageMin = Math.min(shiftXPageMin, --shiftXPage);
            }
            if (shiftXPage != 0) {
                cseq.setOrdinate(i, 0, thisX);
            }
            prevX = thisX;
        }
        if (lineString instanceof LinearRing) {
            assert (cseq.getCoordinate(0).equals((Object)cseq.getCoordinate(size - 1)));
            assert (shiftXPage == 0);
        }
        assert (shiftXPageMax >= 0 && shiftXPageMin <= 0);
        JtsGeometry.shiftGeomByX((Geometry)lineString, shiftXPageMin * -360);
        int crossings = shiftXPageMax - shiftXPageMin;
        return crossings;
    }

    private static void shiftGeomByX(Geometry geom, final int xShift) {
        if (xShift == 0) {
            return;
        }
        geom.apply(new CoordinateSequenceFilter(){

            public void filter(CoordinateSequence seq, int i) {
                seq.setOrdinate(i, 0, seq.getX(i) + (double)xShift);
            }

            public boolean isDone() {
                return false;
            }

            public boolean isGeometryChanged() {
                return true;
            }
        });
    }

    private static Geometry unionGeometryCollection(Geometry geom) {
        if (geom instanceof GeometryCollection) {
            return geom.union();
        }
        return geom;
    }

    private static Geometry cutUnwrappedGeomInto360(Geometry geom) {
        int startPage;
        Envelope geomEnv = geom.getEnvelopeInternal();
        if (geomEnv.getMinX() >= -180.0 && geomEnv.getMaxX() <= 180.0) {
            return geom;
        }
        assert (geom.isValid()) : "geom";
        ArrayList<Geometry> geomList = new ArrayList<Geometry>();
        int page = startPage = (int)Math.floor((geomEnv.getMinX() + 180.0) / 360.0);
        while (true) {
            double minX = -180 + page * 360;
            if (geomEnv.getMaxX() <= minX) break;
            Geometry rect = geom.getFactory().toGeometry(new Envelope(minX, minX + 360.0, -90.0, 90.0));
            assert (rect.isValid()) : "rect";
            Geometry pageGeom = rect.intersection(geom);
            assert (pageGeom.isValid()) : "pageGeom";
            if (page != 0) {
                pageGeom = pageGeom.copy();
                JtsGeometry.shiftGeomByX(pageGeom, page * -360);
            }
            geomList.add(pageGeom);
            ++page;
        }
        return UnaryUnionOp.union(geomList);
    }

    static /* synthetic */ SpatialContext access$000(JtsGeometry x0) {
        return x0.ctx;
    }
}

