/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.util.WKTUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

public abstract class AbstractDirectPosition
extends FormattableObject
implements DirectPosition {
    protected AbstractDirectPosition() {
    }

    public static AbstractDirectPosition castOrCopy(DirectPosition position) {
        if (position == null || position instanceof AbstractDirectPosition) {
            return (AbstractDirectPosition)position;
        }
        return new GeneralDirectPosition(position);
    }

    public final DirectPosition getDirectPosition() {
        return this;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    public double[] getCoordinate() {
        double[] coordinates = new double[this.getDimension()];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = this.getOrdinate(i);
        }
        return coordinates;
    }

    public void setOrdinate(int dimension, double value) {
        throw new UnsupportedOperationException(Errors.format((short)153, this.getClass()));
    }

    public void setLocation(DirectPosition position) throws MismatchedDimensionException, MismatchedReferenceSystemException {
        int dimension = this.getDimension();
        if (position != null) {
            CoordinateReferenceSystem other;
            ArgumentChecks.ensureDimensionMatches((String)"position", (int)dimension, (DirectPosition)position);
            CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
            if (crs != null && (other = position.getCoordinateReferenceSystem()) != null && !Utilities.equalsIgnoreMetadata((Object)crs, (Object)other)) {
                throw new MismatchedReferenceSystemException(Errors.format((short)78));
            }
            for (int i = 0; i < dimension; ++i) {
                this.setOrdinate(i, position.getOrdinate(i));
            }
        } else {
            for (int i = 0; i < dimension; ++i) {
                this.setOrdinate(i, Double.NaN);
            }
        }
    }

    public boolean normalize() {
        boolean changed = false;
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        if (crs != null) {
            int dimension = this.getDimension();
            CoordinateSystem cs = crs.getCoordinateSystem();
            for (int i = 0; i < dimension; ++i) {
                double coordinate = this.getOrdinate(i);
                CoordinateSystemAxis axis = cs.getAxis(i);
                double minimum = axis.getMinimumValue();
                double maximum = axis.getMaximumValue();
                RangeMeaning rm = axis.getRangeMeaning();
                if (RangeMeaning.EXACT.equals((Object)rm)) {
                    if (coordinate < minimum) {
                        coordinate = minimum;
                    } else {
                        if (!(coordinate > maximum)) continue;
                        coordinate = maximum;
                    }
                } else if (RangeMeaning.WRAPAROUND.equals((Object)rm)) {
                    double csSpan = maximum - minimum;
                    double shift = Math.floor((coordinate - minimum) / csSpan) * csSpan;
                    if (shift == 0.0) continue;
                    coordinate -= shift;
                }
                this.setOrdinate(i, coordinate);
                changed = true;
            }
        }
        return changed;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Vector[] points = new Vector[]{Vector.create((double[])this.getCoordinate())};
        formatter.append(points, WKTUtilities.suggestFractionDigits(this.getCoordinateReferenceSystem(), points));
        return "Point";
    }

    @Override
    public String toString() {
        return AbstractDirectPosition.toString(this, false);
    }

    static String toString(DirectPosition position, boolean isSinglePrecision) {
        StringBuilder buffer = new StringBuilder(32).append("POINT");
        int dimension = position.getDimension();
        if (dimension == 0) {
            buffer.append("()");
        } else {
            int separator = 40;
            for (int i = 0; i < dimension; ++i) {
                buffer.append((char)separator);
                double coordinate = position.getOrdinate(i);
                if (isSinglePrecision) {
                    buffer.append((float)coordinate);
                } else {
                    buffer.append(coordinate);
                }
                StringBuilders.trimFractionalPart((StringBuilder)buffer);
                separator = 32;
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    static double[] parse(CharSequence wkt) throws NumberFormatException, IllegalArgumentException {
        int c;
        int length = CharSequences.skipTrailingWhitespaces((CharSequence)wkt, (int)0, (int)wkt.length());
        int i = CharSequences.skipLeadingWhitespaces((CharSequence)wkt, (int)0, (int)length);
        while (true) {
            if (i >= length) {
                return null;
            }
            c = Character.codePointAt(wkt, i);
            if (Character.isUnicodeIdentifierStart(c)) {
                do {
                    if ((i += Character.charCount(c)) < length) continue;
                    return null;
                } while (Character.isUnicodeIdentifierPart(c = Character.codePointAt(wkt, i)));
            }
            if (!Character.isSpaceChar(c)) break;
            i += Character.charCount(c);
        }
        if (c == 40 || c == 91) {
            i += Character.charCount(c);
            char close = c == 40 ? (char)')' : ']';
            int pos = CharSequences.lastIndexOf((CharSequence)wkt, (int)close, (int)(i = CharSequences.skipLeadingWhitespaces((CharSequence)wkt, (int)i, (int)length)), (int)length);
            if (pos != --length) {
                Object[] args;
                short key;
                if (pos < 0) {
                    key = 101;
                    args = new Object[]{wkt, Character.valueOf(close)};
                } else {
                    key = 155;
                    args = new Object[]{"POINT", wkt, CharSequences.trimWhitespaces((CharSequence)wkt, (int)(pos + 1), (int)(length + 1))};
                }
                throw new IllegalArgumentException(Errors.format((short)key, (Object)args));
            }
            c = Character.codePointAt(wkt, i);
        }
        double[] coordinates = new double[2];
        int dimension = 0;
        block2: while (i < length) {
            int start = i;
            do {
                if ((i += Character.charCount(c)) < length) continue;
                c = 0;
                break;
            } while (!Character.isSpaceChar(c = Character.codePointAt(wkt, i)));
            double value = Double.parseDouble(wkt.subSequence(start, i).toString());
            if (dimension == coordinates.length) {
                coordinates = Arrays.copyOf(coordinates, dimension * 2);
            }
            coordinates[dimension++] = value;
            while (Character.isSpaceChar(c)) {
                if ((i += Character.charCount(c)) >= length) break block2;
                c = Character.codePointAt(wkt, i);
            }
        }
        return ArraysExt.resize((double[])coordinates, (int)dimension);
    }

    public int hashCode() {
        int dimension = this.getDimension();
        int code = 1;
        for (int i = 0; i < dimension; ++i) {
            code = code * 31 + Double.hashCode(this.getOrdinate(i));
        }
        return code + Objects.hashCode(this.getCoordinateReferenceSystem());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DirectPosition) {
            DirectPosition that = (DirectPosition)object;
            int dimension = this.getDimension();
            if (dimension == that.getDimension()) {
                for (int i = 0; i < dimension; ++i) {
                    if (Numerics.equals((double)this.getOrdinate(i), (double)that.getOrdinate(i))) continue;
                    return false;
                }
                if (Objects.equals(this.getCoordinateReferenceSystem(), that.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == that.hashCode()) : this;
                    return true;
                }
            }
        }
        return false;
    }
}

