/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.provider.Wraparound;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.util.MathTransformsOrFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public class WraparoundTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -1959034793759509170L;
    private final int dimension;
    public final int wraparoundDimension;
    public final double period;
    public final double sourceMedian;
    private volatile transient MathTransform inverse;

    protected WraparoundTransform(int dimension, int wraparoundDimension, double period, double sourceMedian) {
        this.dimension = dimension;
        this.wraparoundDimension = wraparoundDimension;
        this.period = period;
        this.sourceMedian = sourceMedian;
    }

    protected WraparoundTransform(WraparoundTransform other) {
        this.dimension = other.dimension;
        this.wraparoundDimension = other.wraparoundDimension;
        this.period = other.period;
        this.sourceMedian = other.sourceMedian;
        this.inverse = other.inverse;
    }

    private WraparoundTransform redim(boolean applyOtherFirst, Matrix other) {
        int n = (applyOtherFirst ? other.getNumRow() : other.getNumCol()) - 1;
        if (n == this.dimension) {
            return this;
        }
        if (n < this.wraparoundDimension && this.getClass() == WraparoundTransform.class) {
            return new WraparoundTransform(n, this.wraparoundDimension, this.period, this.sourceMedian);
        }
        return null;
    }

    public static MathTransform create(int dimension, int wraparoundDimension, double period, double sourceMedian, double targetMedian) {
        ArgumentChecks.ensureStrictlyPositive((String)"dimension", (int)dimension);
        ArgumentChecks.ensureBetween((String)"wraparoundDimension", (int)0, (int)(dimension - 1), (int)wraparoundDimension);
        ArgumentChecks.ensureStrictlyPositive((String)"period", (double)period);
        ArgumentChecks.ensureFinite((String)"targetMedian", (double)targetMedian);
        WraparoundTransform tr = new WraparoundTransform(dimension, wraparoundDimension, period, sourceMedian - targetMedian);
        if (targetMedian == 0.0) {
            return tr;
        }
        try {
            double[] vector = new double[dimension];
            vector[wraparoundDimension] = targetMedian;
            LinearTransform denormalize = MathTransforms.translation(vector);
            MathTransform ct = MathTransforms.concatenate(denormalize.inverse(), tr, denormalize);
            if (sourceMedian == 0.0) {
                tr.inverse = tr;
            }
            return ct;
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MathTransform replace(MathTransform transform, Function<? super WraparoundTransform, ? extends WraparoundTransform> replacement) {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)transform);
        ArgumentChecks.ensureNonNull((String)"replacement", replacement);
        if (transform instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)transform;
            MathTransform tr1 = WraparoundTransform.replace(ct.transform1, replacement);
            MathTransform tr2 = WraparoundTransform.replace(ct.transform2, replacement);
            if (tr1 != ct.transform1 || tr2 != ct.transform2) {
                transform = MathTransforms.concatenate(tr1, tr2);
            }
        } else if (transform instanceof WraparoundTransform) {
            transform = Objects.requireNonNull(replacement.apply((WraparoundTransform)transform));
        }
        return transform;
    }

    @Override
    public final int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public final int getTargetDimensions() {
        return this.dimension;
    }

    protected double shift(double x) {
        return Math.IEEEremainder(x, this.period);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        if (dstPts != null) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, this.dimension);
            dstPts[dstOff += this.wraparoundDimension] = this.shift(dstPts[dstOff]);
        }
        return derivate ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * this.dimension);
        dstOff += this.wraparoundDimension;
        while (--numPts >= 0) {
            dstPts[dstOff] = this.shift(dstPts[dstOff]);
            dstOff += this.dimension;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * this.dimension);
        dstOff += this.wraparoundDimension;
        while (--numPts >= 0) {
            dstPts[dstOff] = (float)this.shift(dstPts[dstOff]);
            dstOff += this.dimension;
        }
    }

    @Override
    public Matrix derivative(DirectPosition point) {
        return Matrices.createIdentity(this.dimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform inverse() throws NoninvertibleTransformException {
        MathTransform tr = this.inverse;
        if (tr == null) {
            if (!Double.isFinite(this.sourceMedian)) {
                return super.inverse();
            }
            if (this.sourceMedian == 0.0) {
                this.inverse = tr = this;
            } else {
                WraparoundTransform wraparoundTransform = this;
                synchronized (wraparoundTransform) {
                    tr = this.inverse;
                    if (tr == null) {
                        tr = WraparoundTransform.create(this.dimension, this.wraparoundDimension, this.period, 0.0, this.sourceMedian);
                        ConcatenatedTransform.setInverse(tr, this);
                        this.inverse = tr;
                    }
                }
            }
        }
        return tr;
    }

    @Override
    protected MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
        block10: {
            MathTransform middleTr;
            Matrix middle;
            if (other instanceof WraparoundTransform && this.equalsIgnoreInverse((WraparoundTransform)other)) {
                return applyOtherFirst ? other : this;
            }
            List<MathTransform> steps = MathTransforms.getSteps(other);
            int count = steps.size();
            if (count >= 2 && (middle = MathTransforms.getMatrix(middleTr = steps.get(applyOtherFirst ? count - 1 : 0))) != null) {
                try {
                    MathTransform tr;
                    Matrix remaining;
                    MathTransform step2;
                    Matrix remaining2;
                    WraparoundTransform redim;
                    MathTransformsOrFactory mf = MathTransformsOrFactory.wrap(factory);
                    boolean modified = false;
                    WraparoundTransform step1 = this;
                    MathTransform move = this.movable(middleTr, middle, mf);
                    if (move != null && (redim = this.redim(applyOtherFirst, remaining2 = WraparoundTransform.remaining(applyOtherFirst, move, middle))) != null) {
                        step1 = mf.concatenate(applyOtherFirst, move, redim);
                        middle = remaining2;
                        modified = true;
                    }
                    if ((step2 = steps.get(applyOtherFirst ? count - 2 : 1)) instanceof WraparoundTransform && (move = (redim = (WraparoundTransform)step2).movable(null, middle, mf)) != null && (redim = redim.redim(!applyOtherFirst, remaining = WraparoundTransform.remaining(!applyOtherFirst, move, middle))) != null) {
                        step2 = mf.concatenate(applyOtherFirst, redim, move);
                        middle = remaining;
                        modified = true;
                    }
                    if (!modified || (tr = mf.linear(middle)).getClass() == middleTr.getClass()) break block10;
                    tr = mf.concatenate(applyOtherFirst, tr, step2);
                    tr = mf.concatenate(applyOtherFirst, step1, tr);
                    if (applyOtherFirst) {
                        int i = count - 2;
                        while (--i >= 0) {
                            tr = mf.concatenate(steps.get(i), tr);
                        }
                    } else {
                        for (int i = 2; i < count; ++i) {
                            tr = mf.concatenate(tr, steps.get(i));
                        }
                    }
                    return tr;
                }
                catch (NoninvertibleTransformException e) {
                    Logging.recoverableException((Logger)LOGGER, this.getClass(), (String)"tryConcatenate", (Throwable)e);
                }
            }
        }
        return null;
    }

    private MathTransform movable(MathTransform tr, Matrix matrix, MathTransformsOrFactory factory) throws FactoryException {
        int j;
        long moveAll;
        long canMove = moveAll = Numerics.bitmask((int)this.dimension) - 1L;
        int lastColumn = matrix.getNumCol() - 1;
        if (this.wraparoundDimension < lastColumn) {
            j = matrix.getNumRow();
            while (--j >= 0) {
                double v = matrix.getElement(j, this.wraparoundDimension);
                if (v == (double)(j == this.wraparoundDimension ? 1 : 0)) continue;
                canMove &= Numerics.bitmask((int)j) ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (matrix.getElement(this.wraparoundDimension, lastColumn) != 0.0) {
            canMove &= Numerics.bitmask((int)this.wraparoundDimension) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (canMove != 0L) {
            if (canMove != moveAll) {
                matrix = Matrices.copy(matrix);
                j = matrix.getNumRow() - 1;
                while (--j >= 0) {
                    if ((canMove & Numerics.bitmask((int)j)) != 0L) continue;
                    int i = matrix.getNumCol();
                    while (--i >= 0) {
                        matrix.setElement(j, i, i == j ? 1.0 : 0.0);
                    }
                }
            } else if (tr != null) {
                return tr;
            }
            if (!matrix.isIdentity()) {
                return factory.linear(matrix);
            }
        }
        return null;
    }

    private static Matrix remaining(boolean reverse, MathTransform move, Matrix middle) throws NoninvertibleTransformException {
        Matrix change = MathTransforms.getMatrix(move.inverse());
        return reverse ? Matrices.multiply(change, middle) : Matrices.multiply(middle, change);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Wraparound.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameters pg = Parameters.castOrWrap(this.getParameterDescriptors().createValue());
        pg.getOrCreate(Wraparound.DIMENSION).setValue(this.dimension);
        pg.getOrCreate(Wraparound.WRAPAROUND_DIMENSION).setValue(this.wraparoundDimension);
        pg.getOrCreate(Wraparound.PERIOD).setValue(this.period);
        return pg;
    }

    private boolean equalsIgnoreInverse(WraparoundTransform other) {
        return other.dimension == this.dimension && other.wraparoundDimension == this.wraparoundDimension && Numerics.equals((double)this.period, (double)other.period);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            WraparoundTransform other = (WraparoundTransform)object;
            return this.equalsIgnoreInverse(other) && Numerics.equals((double)this.sourceMedian, (double)other.sourceMedian);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return this.dimension * 31 + this.wraparoundDimension + Double.hashCode(this.period) + 7 * Double.hashCode(this.sourceMedian);
    }
}

