/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.baremaps.openstreetmap.OpenStreetMapFormat;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataColumnFixed;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataSchemaImpl;
import org.apache.baremaps.store.DataTable;

public class OpenStreetMapDataTable
implements DataTable {
    private final DataSchema schema;
    private final OpenStreetMapFormat.EntityReader<Entity> entityReader;
    private final InputStream inputStream;

    public OpenStreetMapDataTable(OpenStreetMapFormat.EntityReader<Entity> entityReader, InputStream inputStream) {
        this.entityReader = entityReader;
        this.inputStream = inputStream;
        this.schema = this.createSchema();
    }

    private DataSchema createSchema() {
        List<DataColumnFixed> columns = List.of(new DataColumnFixed("id", DataColumn.Cardinality.REQUIRED, DataColumn.Type.LONG), new DataColumnFixed("type", DataColumn.Cardinality.REQUIRED, DataColumn.Type.STRING), new DataColumnFixed("version", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.INTEGER), new DataColumnFixed("timestamp", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.LOCAL_DATE_TIME), new DataColumnFixed("uid", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.INTEGER), new DataColumnFixed("user", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.STRING), new DataColumnFixed("changeset", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.LONG), new DataColumnFixed("tags", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.NESTED), new DataColumnFixed("geometry", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.GEOMETRY));
        return new DataSchemaImpl("osm_data", columns);
    }

    public DataSchema schema() {
        return this.schema;
    }

    public boolean add(DataRow row) {
        throw new UnsupportedOperationException("Add operation is not supported for OpenStreetMapDataTable.");
    }

    public void clear() {
        throw new UnsupportedOperationException("Clear operation is not supported for OpenStreetMapDataTable.");
    }

    public long size() {
        return Long.MAX_VALUE;
    }

    public Iterator<DataRow> iterator() {
        Stream<Element> elementStream = ((Stream)this.entityReader.read(this.inputStream)).filter(element -> element instanceof Element).map(element -> (Element)element);
        return elementStream.map(this::elementToDataRow).iterator();
    }

    private DataRow elementToDataRow(Element element) {
        DataRow row = this.schema.createRow();
        row.set("id", (Object)element.getId());
        row.set("type", (Object)this.elementTypeToString(element));
        row.set("version", (Object)element.getInfo().getVersion());
        row.set("timestamp", (Object)element.getInfo().getTimestamp());
        row.set("uid", (Object)element.getInfo().getUid());
        row.set("changeset", (Object)element.getInfo().getChangeset());
        row.set("tags", element.getTags());
        row.set("geometry", (Object)element.getGeometry());
        return row;
    }

    private String elementTypeToString(Element element) {
        if (element instanceof Node) {
            return "node";
        }
        if (element instanceof Way) {
            return "way";
        }
        if (element instanceof Relation) {
            return "relation";
        }
        return "unknown";
    }
}

