/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlJoin
extends SqlCall {
    static final SqlJoinOperator COMMA_OPERATOR = new SqlJoinOperator("COMMA-JOIN", 16);
    public static final SqlJoinOperator OPERATOR = new SqlJoinOperator("JOIN", 18);
    SqlNode left;
    SqlLiteral natural;
    SqlLiteral joinType;
    SqlNode right;
    SqlLiteral conditionType;
    @Nullable SqlNode condition;

    public SqlJoin(SqlParserPos pos, SqlNode left, SqlLiteral natural, SqlLiteral joinType, SqlNode right, SqlLiteral conditionType, @Nullable SqlNode condition) {
        super(pos);
        this.left = left;
        this.natural = Objects.requireNonNull(natural, "natural");
        this.joinType = Objects.requireNonNull(joinType, "joinType");
        this.right = right;
        this.conditionType = Objects.requireNonNull(conditionType, "conditionType");
        this.condition = condition;
        Preconditions.checkArgument((natural.getTypeName() == SqlTypeName.BOOLEAN ? 1 : 0) != 0);
        conditionType.getValueAs(JoinConditionType.class);
        joinType.getValueAs(JoinType.class);
    }

    @Override
    public SqlOperator getOperator() {
        switch (this.getJoinType()) {
            case COMMA: {
                return COMMA_OPERATOR;
            }
        }
        return OPERATOR;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.JOIN;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.left, this.natural, this.joinType, this.right, this.conditionType, this.condition);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.left = operand;
                break;
            }
            case 1: {
                this.natural = (SqlLiteral)operand;
                break;
            }
            case 2: {
                this.joinType = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.right = operand;
                break;
            }
            case 4: {
                this.conditionType = (SqlLiteral)operand;
                break;
            }
            case 5: {
                this.condition = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public final @Nullable SqlNode getCondition() {
        return this.condition;
    }

    public final JoinConditionType getConditionType() {
        return this.conditionType.getValueAs(JoinConditionType.class);
    }

    public SqlLiteral getConditionTypeNode() {
        return this.conditionType;
    }

    public final JoinType getJoinType() {
        return this.joinType.getValueAs(JoinType.class);
    }

    public SqlLiteral getJoinTypeNode() {
        return this.joinType;
    }

    public final SqlNode getLeft() {
        return this.left;
    }

    public void setLeft(SqlNode left) {
        this.left = left;
    }

    public final boolean isNatural() {
        return this.natural.booleanValue();
    }

    public final SqlLiteral isNaturalNode() {
        return this.natural;
    }

    public final SqlNode getRight() {
        return this.right;
    }

    public void setRight(SqlNode right) {
        this.right = right;
    }

    @Override
    public SqlString toSqlString(UnaryOperator<SqlWriterConfig> transform) {
        SqlSelect selectWrapper = new SqlSelect(SqlParserPos.ZERO, SqlNodeList.EMPTY, SqlNodeList.SINGLETON_STAR, this, null, null, null, SqlNodeList.EMPTY, null, null, null, null, SqlNodeList.EMPTY);
        return selectWrapper.toSqlString(transform);
    }

    public static class SqlJoinOperator
    extends SqlOperator {
        private static final SqlWriter.FrameType FRAME_TYPE = SqlWriter.FrameTypeEnum.create("USING");

        private SqlJoinOperator(String name, int prec) {
            super(name, SqlKind.JOIN, prec, true, null, null, null);
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            return new SqlJoin(pos, operands[0], (SqlLiteral)operands[1], (SqlLiteral)operands[2], operands[3], (SqlLiteral)operands[4], operands[5]);
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlJoin join = (SqlJoin)call;
            join.left.unparse(writer, leftPrec, this.getLeftPrec());
            switch (join.getJoinType()) {
                case COMMA: {
                    writer.sep(",", true);
                    break;
                }
                case CROSS: {
                    writer.sep(join.isNatural() ? "NATURAL CROSS JOIN" : "CROSS JOIN");
                    break;
                }
                case FULL: {
                    writer.sep(join.isNatural() ? "NATURAL FULL JOIN" : "FULL JOIN");
                    break;
                }
                case INNER: {
                    writer.sep(join.isNatural() ? "NATURAL INNER JOIN" : "INNER JOIN");
                    break;
                }
                case LEFT: {
                    writer.sep(join.isNatural() ? "NATURAL LEFT JOIN" : "LEFT JOIN");
                    break;
                }
                case LEFT_SEMI_JOIN: {
                    writer.sep(join.isNatural() ? "NATURAL LEFT SEMI JOIN" : "LEFT SEMI JOIN");
                    break;
                }
                case LEFT_ANTI_JOIN: {
                    writer.sep(join.isNatural() ? "NATURAL LEFT ANTI JOIN" : "LEFT ANTI JOIN");
                    break;
                }
                case RIGHT: {
                    writer.sep(join.isNatural() ? "NATURAL RIGHT JOIN" : "RIGHT JOIN");
                    break;
                }
                default: {
                    throw Util.unexpected(join.getJoinType());
                }
            }
            join.right.unparse(writer, this.getRightPrec(), rightPrec);
            SqlNode joinCondition = join.condition;
            if (joinCondition != null) {
                switch (join.getConditionType()) {
                    case USING: {
                        writer.keyword("USING");
                        assert (joinCondition instanceof SqlNodeList) : "joinCondition should be SqlNodeList, got " + joinCondition;
                        SqlWriter.Frame frame = writer.startList(FRAME_TYPE, "(", ")");
                        joinCondition.unparse(writer, 0, 0);
                        writer.endList(frame);
                        break;
                    }
                    case ON: {
                        writer.keyword("ON");
                        joinCondition.unparse(writer, leftPrec, rightPrec);
                        break;
                    }
                    default: {
                        throw Util.unexpected(join.getConditionType());
                    }
                }
            }
        }
    }
}

