/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.List;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageImpl;
import mil.nga.geopackage.contents.ContentsDataType;
import mil.nga.geopackage.db.GeoPackageConnection;
import mil.nga.geopackage.dgiwg.CoordinateReferenceSystem;
import mil.nga.geopackage.dgiwg.DGIWGGeoPackageUtils;
import mil.nga.geopackage.dgiwg.DGIWGMetadata;
import mil.nga.geopackage.dgiwg.DGIWGRequirement;
import mil.nga.geopackage.dgiwg.DGIWGValidate;
import mil.nga.geopackage.dgiwg.DGIWGValidationError;
import mil.nga.geopackage.dgiwg.DGIWGValidationErrors;
import mil.nga.geopackage.dgiwg.DGIWGValidationKey;
import mil.nga.geopackage.dgiwg.DataType;
import mil.nga.geopackage.dgiwg.GeoPackageFile;
import mil.nga.geopackage.dgiwg.GeoPackageFileName;
import mil.nga.geopackage.extension.metadata.Metadata;
import mil.nga.geopackage.extension.metadata.MetadataScopeType;
import mil.nga.geopackage.extension.metadata.reference.MetadataReference;
import mil.nga.geopackage.extension.rtree.RTreeIndexExtension;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.srs.SpatialReferenceSystem;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.user.TileColumn;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.geopackage.tiles.user.TileResultSet;
import mil.nga.geopackage.tiles.user.TileRow;
import mil.nga.sf.GeometryType;

public class DGIWGGeoPackage
extends GeoPackageImpl {
    private final GeoPackageFile file;
    private DGIWGValidationErrors errors;

    public DGIWGGeoPackage(GeoPackage geoPackage) {
        super(geoPackage.getName(), geoPackage.getPath(), geoPackage.getConnection());
        this.file = new GeoPackageFile(geoPackage.getPath());
    }

    public DGIWGGeoPackage(GeoPackageFileName fileName, GeoPackage geoPackage) {
        super(geoPackage.getName(), geoPackage.getPath(), geoPackage.getConnection());
        this.file = new GeoPackageFile(this.getPath(), fileName);
    }

    protected DGIWGGeoPackage(String name, File file, GeoPackageConnection database) {
        super(name, file, database);
        this.file = new GeoPackageFile(file);
    }

    public GeoPackageFile getFile() {
        return this.file;
    }

    public GeoPackageFileName getFileName() {
        return this.file.getFileName();
    }

    public boolean isValid() {
        return this.validate().isValid();
    }

    public DGIWGValidationErrors validate() {
        this.errors = DGIWGValidate.validate((GeoPackageCore)this);
        this.validate(this.errors, this.getTables());
        return this.errors;
    }

    public DGIWGValidationErrors getErrors() {
        return this.errors;
    }

    public DGIWGValidationErrors validate(String table) {
        DGIWGValidationErrors errors = DGIWGValidate.validate((GeoPackageCore)this, (String)table);
        this.validate(errors, table);
        return errors;
    }

    public DGIWGValidationErrors validate(List<String> tables) {
        DGIWGValidationErrors errors = DGIWGValidate.validate((GeoPackageCore)this, tables);
        this.validate(errors, tables);
        return errors;
    }

    private void validate(DGIWGValidationErrors errors, List<String> tables) {
        for (String table : tables) {
            this.validate(errors, table);
        }
    }

    private void validate(DGIWGValidationErrors errors, String table) {
        ContentsDataType dataType = this.getTableCoreDataType(table);
        if (dataType != null) {
            switch (dataType) {
                case TILES: {
                    this.validateTileTable(errors, table);
                    break;
                }
            }
        }
    }

    private void validateTileTable(DGIWGValidationErrors errors, String table) {
        TileDao tileDao = this.getTileDao(table);
        try (TileResultSet resultSet = (TileResultSet)tileDao.query();){
            if (resultSet.moveToNext()) {
                TileRow tileRow = (TileRow)resultSet.getRow();
                BufferedImage tile = tileRow.getTileDataImage();
                if (tile == null || tile.getWidth() != 256) {
                    errors.add(new DGIWGValidationError(table, tileRow.getTileDataColumn().getName(), (Number)(tile != null ? Integer.valueOf(tile.getWidth()) : null), "Tile width of 256", DGIWGRequirement.TILE_SIZE_DATA, new DGIWGValidationKey[]{new DGIWGValidationKey(((TileColumn)tileRow.getPkColumn()).getName(), (Number)tileRow.getId())}));
                }
                if (tile == null || tile.getHeight() != 256) {
                    errors.add(new DGIWGValidationError(table, tileRow.getTileDataColumn().getName(), (Number)(tile != null ? Integer.valueOf(tile.getHeight()) : null), "Tile height of 256", DGIWGRequirement.TILE_SIZE_DATA, new DGIWGValidationKey[]{new DGIWGValidationKey(((TileColumn)tileRow.getPkColumn()).getName(), (Number)tileRow.getId())}));
                }
            }
        }
    }

    public TileMatrixSet createTiles(String table, CoordinateReferenceSystem crs) {
        return this.createTiles(table, table, table, crs);
    }

    public TileMatrixSet createTiles(String table, String identifier, String description, CoordinateReferenceSystem crs) {
        return this.createTiles(table, identifier, description, null, crs);
    }

    public TileMatrixSet createTiles(String table, String identifier, String description, BoundingBox informativeBounds, CoordinateReferenceSystem crs) {
        SpatialReferenceSystem srs = crs.createTilesSpatialReferenceSystem();
        return this.createTiles(table, identifier, description, informativeBounds, srs, crs.getBounds());
    }

    public TileMatrixSet createTiles(String table, CoordinateReferenceSystem crs, BoundingBox extentBounds) {
        return this.createTiles(table, table, table, crs, extentBounds);
    }

    public TileMatrixSet createTiles(String table, String identifier, String description, CoordinateReferenceSystem crs, BoundingBox extentBounds) {
        return this.createTiles(table, identifier, description, null, crs, extentBounds);
    }

    public TileMatrixSet createTiles(String table, String identifier, String description, BoundingBox informativeBounds, CoordinateReferenceSystem crs, BoundingBox extentBounds) {
        return this.createTiles(table, identifier, description, informativeBounds, crs.createTilesSpatialReferenceSystem(), extentBounds);
    }

    public TileMatrixSet createTiles(String table, SpatialReferenceSystem srs, BoundingBox extentBounds) {
        return this.createTiles(table, table, table, srs, extentBounds);
    }

    public TileMatrixSet createTiles(String table, String identifier, String description, SpatialReferenceSystem srs, BoundingBox extentBounds) {
        return this.createTiles(table, identifier, description, null, srs, extentBounds);
    }

    public TileMatrixSet createTiles(String table, String identifier, String description, BoundingBox informativeBounds, SpatialReferenceSystem srs, BoundingBox extentBounds) {
        return DGIWGGeoPackageUtils.createTiles((GeoPackageCore)this, (String)table, (String)identifier, (String)description, (BoundingBox)informativeBounds, (SpatialReferenceSystem)srs, (BoundingBox)extentBounds);
    }

    public void createTileMatrices(TileMatrixSet tileMatrixSet, long minZoom, long maxZoom, long matrixWidth, long matrixHeight) {
        this.createTileMatrices(tileMatrixSet.getTableName(), tileMatrixSet.getBoundingBox(), minZoom, maxZoom, matrixWidth, matrixHeight);
    }

    public void createTileMatrices(String table, BoundingBox boundingBox, long minZoom, long maxZoom, long matrixWidth, long matrixHeight) {
        DGIWGGeoPackageUtils.createTileMatrices((GeoPackageCore)this, (String)table, (BoundingBox)boundingBox, (long)minZoom, (long)maxZoom, (long)matrixWidth, (long)matrixHeight);
    }

    public void createTileMatrices(TileMatrixSet tileMatrixSet, Collection<Long> zoomLevels, long matrixWidth, long matrixHeight) {
        this.createTileMatrices(tileMatrixSet.getTableName(), tileMatrixSet.getBoundingBox(), zoomLevels, matrixWidth, matrixHeight);
    }

    public void createTileMatrices(String table, BoundingBox boundingBox, Collection<Long> zoomLevels, long matrixWidth, long matrixHeight) {
        DGIWGGeoPackageUtils.createTileMatrices((GeoPackageCore)this, (String)table, (BoundingBox)boundingBox, zoomLevels, (long)matrixWidth, (long)matrixHeight);
    }

    public void createTileMatrix(TileMatrixSet tileMatrixSet, long zoom, long matrixWidth, long matrixHeight) {
        this.createTileMatrix(tileMatrixSet.getTableName(), tileMatrixSet.getBoundingBox(), zoom, matrixWidth, matrixHeight);
    }

    public void createTileMatrix(String table, BoundingBox boundingBox, long zoom, long matrixWidth, long matrixHeight) {
        DGIWGGeoPackageUtils.createTileMatrix((GeoPackageCore)this, (String)table, (BoundingBox)boundingBox, (long)zoom, (long)matrixWidth, (long)matrixHeight);
    }

    public void createTileMatrix(String table, long zoom, long matrixWidth, long matrixHeight, double pixelXSize, double pixelYSize) {
        DGIWGGeoPackageUtils.createTileMatrix((GeoPackageCore)this, (String)table, (long)zoom, (long)matrixWidth, (long)matrixHeight, (double)pixelXSize, (double)pixelYSize);
    }

    public GeometryColumns createFeatures(String table, GeometryType geometryType, CoordinateReferenceSystem crs) {
        return this.createFeatures(table, geometryType, null, crs);
    }

    public GeometryColumns createFeatures(String table, GeometryType geometryType, List<FeatureColumn> columns, CoordinateReferenceSystem crs) {
        return this.createFeatures(table, table, table, geometryType, columns, crs);
    }

    public GeometryColumns createFeatures(String table, String identifier, String description, GeometryType geometryType, CoordinateReferenceSystem crs) {
        return this.createFeatures(table, identifier, description, geometryType, null, crs);
    }

    public GeometryColumns createFeatures(String table, String identifier, String description, GeometryType geometryType, List<FeatureColumn> columns, CoordinateReferenceSystem crs) {
        SpatialReferenceSystem srs = crs.createFeaturesSpatialReferenceSystem();
        DataType dataType = (DataType)crs.getFeaturesDataTypes().iterator().next();
        return this.createFeatures(table, identifier, description, crs.getBounds(), geometryType, dataType, columns, srs);
    }

    public GeometryColumns createFeatures(String table, BoundingBox bounds, GeometryType geometryType, CoordinateReferenceSystem crs) {
        return this.createFeatures(table, bounds, geometryType, null, crs);
    }

    public GeometryColumns createFeatures(String table, BoundingBox bounds, GeometryType geometryType, List<FeatureColumn> columns, CoordinateReferenceSystem crs) {
        return this.createFeatures(table, table, table, bounds, geometryType, columns, crs);
    }

    public GeometryColumns createFeatures(String table, String identifier, String description, BoundingBox bounds, GeometryType geometryType, CoordinateReferenceSystem crs) {
        return this.createFeatures(table, identifier, description, bounds, geometryType, null, crs);
    }

    public GeometryColumns createFeatures(String table, String identifier, String description, BoundingBox bounds, GeometryType geometryType, List<FeatureColumn> columns, CoordinateReferenceSystem crs) {
        SpatialReferenceSystem srs = crs.createFeaturesSpatialReferenceSystem();
        DataType dataType = (DataType)crs.getFeaturesDataTypes().iterator().next();
        return this.createFeatures(table, identifier, description, bounds, geometryType, dataType, columns, srs);
    }

    public GeometryColumns createFeatures(String table, BoundingBox bounds, GeometryType geometryType, DataType dataType, SpatialReferenceSystem srs) {
        return this.createFeatures(table, bounds, geometryType, dataType, null, srs);
    }

    public GeometryColumns createFeatures(String table, BoundingBox bounds, GeometryType geometryType, DataType dataType, List<FeatureColumn> columns, SpatialReferenceSystem srs) {
        return this.createFeatures(table, table, table, bounds, geometryType, dataType, columns, srs);
    }

    public GeometryColumns createFeatures(String table, String identifier, String description, BoundingBox bounds, GeometryType geometryType, DataType dataType, SpatialReferenceSystem srs) {
        return this.createFeatures(table, identifier, description, bounds, geometryType, dataType, null, srs);
    }

    public GeometryColumns createFeatures(String table, String identifier, String description, BoundingBox bounds, GeometryType geometryType, DataType dataType, List<FeatureColumn> columns, SpatialReferenceSystem srs) {
        GeometryColumns geometryColumns = DGIWGGeoPackageUtils.createFeatures((GeoPackageCore)this, (String)table, (String)identifier, (String)description, (BoundingBox)bounds, (GeometryType)geometryType, (DataType)dataType, columns, (SpatialReferenceSystem)srs);
        RTreeIndexExtension extension = new RTreeIndexExtension(this);
        extension.create((FeatureTable)this.getFeatureDao(geometryColumns).getTable());
        return geometryColumns;
    }

    public void createMetadata(Metadata metadata, MetadataReference reference) {
        DGIWGGeoPackageUtils.createMetadata((GeoPackageCore)this, (Metadata)metadata, (MetadataReference)reference);
    }

    public void createMetadata(Metadata metadata) {
        DGIWGGeoPackageUtils.createMetadata((GeoPackageCore)this, (Metadata)metadata);
    }

    public void createMetadataReference(Metadata metadata, MetadataReference reference) {
        DGIWGGeoPackageUtils.createMetadataReference((GeoPackageCore)this, (Metadata)metadata, (MetadataReference)reference);
    }

    public void createMetadataReference(MetadataReference reference) {
        DGIWGGeoPackageUtils.createMetadataReference((GeoPackageCore)this, (MetadataReference)reference);
    }

    public MetadataReference createGeoPackageSeriesMetadata(String uri, String metadata) {
        return DGIWGGeoPackageUtils.createGeoPackageSeriesMetadata((GeoPackageCore)this, (String)uri, (String)metadata);
    }

    public MetadataReference createGeoPackageDatasetMetadata(String uri, String metadata) {
        return DGIWGGeoPackageUtils.createGeoPackageDatasetMetadata((GeoPackageCore)this, (String)uri, (String)metadata);
    }

    public MetadataReference createGeoPackageMetadata(MetadataScopeType scope, String uri, String metadata) {
        return DGIWGGeoPackageUtils.createGeoPackageMetadata((GeoPackageCore)this, (MetadataScopeType)scope, (String)uri, (String)metadata);
    }

    public MetadataReference createMetadata(MetadataScopeType scope, String uri, String metadata, MetadataReference reference) {
        return DGIWGGeoPackageUtils.createMetadata((GeoPackageCore)this, (MetadataScopeType)scope, (String)uri, (String)metadata, (MetadataReference)reference);
    }

    public List<MetadataReference> queryGeoPackageDMFMetadata() {
        return DGIWGMetadata.queryGeoPackageDMFMetadata((GeoPackageCore)this);
    }

    public List<MetadataReference> queryGeoPackageNASMetadata() {
        return DGIWGMetadata.queryGeoPackageNASMetadata((GeoPackageCore)this);
    }

    public List<MetadataReference> queryGeoPackageMetadata(String baseURI) {
        return DGIWGMetadata.queryGeoPackageMetadata((GeoPackageCore)this, (String)baseURI);
    }
}

