/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geocoder;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.baremaps.geocoder.GeocoderConstants;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataSchema;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class DataTableQueryBuilder {
    private final Analyzer analyzer;
    private Map<String, Float> fields = new HashMap<String, Float>();
    private String query;

    public DataTableQueryBuilder() {
        this(GeocoderConstants.ANALYZER);
    }

    public DataTableQueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public DataTableQueryBuilder schema(DataSchema schema) {
        this.fields = new HashMap<String, Float>(schema.columns().stream().collect(Collectors.toMap(DataColumn::name, column -> Float.valueOf(1.0f))));
        return this;
    }

    public DataTableQueryBuilder columns(Map<DataColumn, Float> fields) {
        this.fields = new HashMap<String, Float>(fields.entrySet().stream().collect(Collectors.toMap(entry -> ((DataColumn)entry.getKey()).name(), Map.Entry::getValue)));
        return this;
    }

    public DataTableQueryBuilder column(DataColumn column, float boost) {
        return this.column(column.name(), boost);
    }

    public DataTableQueryBuilder column(String column, float boost) {
        this.fields.put(column, Float.valueOf(boost));
        return this;
    }

    public DataTableQueryBuilder query(String query) {
        this.query = query;
        return this;
    }

    public Query build() {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        SimpleQueryParser parser = new SimpleQueryParser(this.analyzer, this.fields);
        String escapedQuery = QueryParserBase.escape((String)this.query);
        Query termsQuery = parser.parse(escapedQuery);
        builder.add(termsQuery, BooleanClause.Occur.MUST);
        return builder.build();
    }
}

