/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit.sharedterms;

import java.io.IOException;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.codecs.uniformsplit.sharedterms.STUniformSplitTermsWriter;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;

class STMergingTermsEnum
extends TermsEnum {
    protected final String fieldName;
    protected final MultiSegmentsPostingsEnum multiPostingsEnum;
    protected BytesRef term;

    protected STMergingTermsEnum(String fieldName, int numSegments) {
        this.fieldName = fieldName;
        this.multiPostingsEnum = new MultiSegmentsPostingsEnum(numSegments);
    }

    protected void reset(BytesRef term, List<STUniformSplitTermsWriter.SegmentPostings> segmentPostings) {
        this.term = term;
        this.multiPostingsEnum.reset(segmentPostings);
    }

    public AttributeSource attributes() {
        throw new UnsupportedOperationException();
    }

    public boolean seekExact(BytesRef text) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TermsEnum.SeekStatus seekCeil(BytesRef text) {
        throw new UnsupportedOperationException();
    }

    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    public void seekExact(BytesRef term, TermState state) throws IOException {
        throw new UnsupportedOperationException();
    }

    public BytesRef term() {
        return this.term;
    }

    public long ord() {
        throw new UnsupportedOperationException();
    }

    public int docFreq() {
        throw new UnsupportedOperationException();
    }

    public long totalTermFreq() {
        throw new UnsupportedOperationException();
    }

    public PostingsEnum postings(PostingsEnum reuse, int flags) {
        this.multiPostingsEnum.setPostingFlags(flags);
        return this.multiPostingsEnum;
    }

    public ImpactsEnum impacts(int flags) {
        throw new UnsupportedOperationException();
    }

    public TermState termState() {
        throw new UnsupportedOperationException();
    }

    public BytesRef next() {
        throw new UnsupportedOperationException();
    }

    protected class MultiSegmentsPostingsEnum
    extends PostingsEnum {
        protected final PostingsEnum[] reusablePostingsEnums;
        protected List<STUniformSplitTermsWriter.SegmentPostings> segmentPostingsList;
        protected int segmentIndex;
        protected PostingsEnum postingsEnum;
        protected boolean postingsEnumExhausted;
        protected MergeState.DocMap docMap;
        protected int docId;
        protected int postingsFlags;

        protected MultiSegmentsPostingsEnum(int numSegments) {
            this.reusablePostingsEnums = new PostingsEnum[numSegments];
        }

        protected void reset(List<STUniformSplitTermsWriter.SegmentPostings> segmentPostingsList) {
            assert (segmentPostingsList instanceof RandomAccess) : "We optimize by accessing the list elements instead of creating an Iterator";
            this.segmentPostingsList = segmentPostingsList;
            this.segmentIndex = -1;
            this.postingsEnumExhausted = true;
            this.docId = -1;
        }

        protected void setPostingFlags(int flags) {
            this.postingsFlags = flags;
        }

        public int freq() throws IOException {
            return this.postingsEnum.freq();
        }

        public int nextPosition() throws IOException {
            return this.postingsEnum.nextPosition();
        }

        public int startOffset() throws IOException {
            return this.postingsEnum.startOffset();
        }

        public int endOffset() throws IOException {
            return this.postingsEnum.endOffset();
        }

        public BytesRef getPayload() throws IOException {
            return this.postingsEnum.getPayload();
        }

        public int docID() {
            return this.docId;
        }

        public int nextDoc() throws IOException {
            int docId;
            assert (this.segmentPostingsList != null) : "reset not called";
            while (true) {
                if (this.postingsEnumExhausted) {
                    if (this.segmentIndex == this.segmentPostingsList.size() - 1) {
                        this.docId = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    ++this.segmentIndex;
                    STUniformSplitTermsWriter.SegmentPostings segmentPostings = this.segmentPostingsList.get(this.segmentIndex);
                    this.postingsEnum = this.getPostings(segmentPostings);
                    this.postingsEnumExhausted = false;
                    this.docMap = segmentPostings.docMap;
                }
                if ((docId = this.postingsEnum.nextDoc()) == Integer.MAX_VALUE) {
                    this.postingsEnumExhausted = true;
                    continue;
                }
                if ((docId = this.docMap.get(docId)) != -1) break;
            }
            assert (docId > this.docId) : "next docId=" + docId + ", current docId=" + this.docId;
            this.docId = docId;
            return this.docId;
        }

        protected PostingsEnum getPostings(STUniformSplitTermsWriter.SegmentPostings segmentPostings) throws IOException {
            this.reusablePostingsEnums[segmentPostings.segmentIndex] = segmentPostings.getPostings(STMergingTermsEnum.this.fieldName, this.reusablePostingsEnums[segmentPostings.segmentIndex], this.postingsFlags);
            return this.reusablePostingsEnums[segmentPostings.segmentIndex];
        }

        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            return 0L;
        }
    }
}

