/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.DataTransfer;
import org.apache.sis.io.stream.MemoryDataTransfer;
import org.apache.sis.io.stream.Region;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.util.resources.Errors;

public class HyperRectangleReader {
    private final DataTransfer reader;
    private long origin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HyperRectangleReader(byte dataType, ChannelDataInput input) throws DataStoreContentException {
        switch (dataType) {
            case 3: {
                ChannelDataInput channelDataInput = input;
                Objects.requireNonNull(channelDataInput);
                this.reader = channelDataInput.new ChannelDataInput.BytesReader(null);
                break;
            }
            case 2: {
                ChannelDataInput channelDataInput = input;
                Objects.requireNonNull(channelDataInput);
                this.reader = channelDataInput.new ChannelDataInput.CharsReader((char[])null);
                break;
            }
            case 4: {
                ChannelDataInput channelDataInput = input;
                Objects.requireNonNull(channelDataInput);
                this.reader = channelDataInput.new ChannelDataInput.ShortsReader((short[])null);
                break;
            }
            case 5: {
                ChannelDataInput channelDataInput = input;
                Objects.requireNonNull(channelDataInput);
                this.reader = channelDataInput.new ChannelDataInput.IntsReader((int[])null);
                break;
            }
            case 6: {
                ChannelDataInput channelDataInput = input;
                Objects.requireNonNull(channelDataInput);
                this.reader = channelDataInput.new ChannelDataInput.LongsReader((long[])null);
                break;
            }
            case 8: {
                ChannelDataInput channelDataInput = input;
                Objects.requireNonNull(channelDataInput);
                this.reader = channelDataInput.new ChannelDataInput.FloatsReader((float[])null);
                break;
            }
            case 9: {
                ChannelDataInput channelDataInput = input;
                Objects.requireNonNull(channelDataInput);
                this.reader = channelDataInput.new ChannelDataInput.DoublesReader((double[])null);
                break;
            }
            default: {
                throw new DataStoreContentException(Errors.format((short)149, (Object)dataType));
            }
        }
        ByteBuffer buffer = input.buffer;
        int pos = buffer.position();
        int lim = buffer.limit();
        try {
            buffer.position(0).limit(buffer.capacity());
            this.reader.createView();
        }
        finally {
            buffer.limit(lim).position(pos);
        }
    }

    public HyperRectangleReader(String filename, Buffer data) throws IOException {
        this.reader = new MemoryDataTransfer(filename, data).reader();
    }

    public final String filename() {
        return this.reader.filename();
    }

    public final int sampleSize() {
        return 1 << this.reader.dataSizeShift();
    }

    public final long getOrigin() {
        return this.origin;
    }

    public final void setOrigin(long p) {
        this.origin = p;
    }

    public final Object read(Region region) throws IOException {
        return this.read(region, 0, false);
    }

    public final Buffer readAsBuffer(Region region, int capacity) throws IOException {
        return (Buffer)this.read(region, capacity, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object read(Region region, int capacity, boolean asBuffer) throws IOException {
        int contiguousDataDimension = region.contiguousDataDimension();
        int contiguousDataLength = region.targetLength(contiguousDataDimension);
        long[] strides = new long[region.getDimension() - contiguousDataDimension];
        int[] cursor = new int[strides.length];
        int sampleSize = this.sampleSize();
        long streamPosition = Math.addExact(this.origin, region.offset(sampleSize));
        int arrayPosition = 0;
        for (int i = 0; i < strides.length; ++i) {
            strides[i] = region.stride(i + contiguousDataDimension, contiguousDataLength, sampleSize);
            assert (strides[i] > 0L) : i;
        }
        int limit = region.targetLength(region.getDimension());
        try {
            this.reader.createDataArray(Math.max(capacity, limit));
            Buffer view = this.reader.view();
            block4: while (true) {
                this.reader.seek(streamPosition);
                assert (this.reader.view() == view);
                this.reader.readFully(view, arrayPosition, contiguousDataLength);
                for (int i = 0; i < cursor.length; ++i) {
                    int n = i;
                    cursor[n] = cursor[n] + 1;
                    if (cursor[n] < region.targetSize[contiguousDataDimension + i]) {
                        streamPosition = Math.addExact(streamPosition, strides[i]);
                        arrayPosition = Math.addExact(arrayPosition, contiguousDataLength);
                        continue block4;
                    }
                    cursor[i] = 0;
                }
                break;
            }
            Object object = asBuffer ? this.reader.dataArrayAsBuffer().limit(limit) : this.reader.dataArray();
            return object;
        }
        finally {
            this.reader.setDest(null);
        }
    }
}

