/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeObserver;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;

abstract class AbstractLandscapeHandler
implements IHTTPRequestHandler {
    protected final Map<String, IBaseKVLandscapeObserver> landscapeObservers = new ConcurrentHashMap<String, IBaseKVLandscapeObserver>();
    private final IBaseKVMetaService metaService;
    private final CompositeDisposable disposable = new CompositeDisposable();

    protected AbstractLandscapeHandler(IBaseKVMetaService metaService) {
        this.metaService = metaService;
    }

    @Override
    public void start() {
        this.disposable.add(this.metaService.clusterIds().subscribe(clusterIds -> {
            this.landscapeObservers.keySet().removeIf(clusterId -> !clusterIds.contains(clusterId));
            for (String clusterId2 : clusterIds) {
                this.landscapeObservers.computeIfAbsent(clusterId2, arg_0 -> ((IBaseKVMetaService)this.metaService).landscapeObserver(arg_0));
            }
        }));
    }

    @Override
    public void close() {
        this.disposable.dispose();
        this.landscapeObservers.values().forEach(IBaseKVLandscapeObserver::stop);
    }
}

