/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.server.handler;

import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.dist.rpc.proto.MatchReply;
import org.apache.bifromq.dist.rpc.proto.MatchRequest;
import org.apache.bifromq.dist.server.handler.IDistServiceReqHandler;
import org.apache.bifromq.dist.server.scheduler.IMatchCallScheduler;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.distservice.MatchError;
import org.apache.bifromq.plugin.eventcollector.distservice.Matched;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchReqHandler
implements IDistServiceReqHandler<MatchRequest, MatchReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MatchReqHandler.class);
    private final IEventCollector eventCollector;
    private final IMatchCallScheduler matchCallScheduler;

    public MatchReqHandler(IEventCollector eventCollector, IMatchCallScheduler matchCallScheduler) {
        this.eventCollector = eventCollector;
        this.matchCallScheduler = matchCallScheduler;
    }

    @Override
    public CompletableFuture<MatchReply> handle(MatchRequest request) {
        return this.matchCallScheduler.schedule(request).handle(CompletableFutureUtil.unwrap((v, e) -> {
            if (e != null) {
                log.debug("Failed to exec SubRequest, tenantId={}, req={}", new Object[]{request.getTenantId(), request, e});
                this.eventCollector.report((Event)((MatchError)ThreadLocalEventPool.getLocal(MatchError.class)).reqId(request.getReqId()).tenantId(request.getTenantId()).topicFilter(request.getMatcher().getMqttTopicFilter()).receiverId(request.getReceiverId()).subBrokerId(request.getBrokerId()).delivererKey(request.getDelivererKey()).reason(e.getMessage()));
                if (e instanceof BackPressureException) {
                    return MatchReply.newBuilder().setReqId(request.getReqId()).setResult(MatchReply.Result.BACK_PRESSURE_REJECTED).build();
                }
                return MatchReply.newBuilder().setReqId(request.getReqId()).setResult(MatchReply.Result.ERROR).build();
            }
            switch (v.getResult()) {
                case OK: {
                    this.eventCollector.report((Event)((Matched)ThreadLocalEventPool.getLocal(Matched.class)).reqId(request.getReqId()).tenantId(request.getTenantId()).topicFilter(request.getMatcher().getMqttTopicFilter()).receiverId(request.getReceiverId()).subBrokerId(request.getBrokerId()).delivererKey(request.getDelivererKey()));
                    break;
                }
                case EXCEED_LIMIT: {
                    this.eventCollector.report((Event)((MatchError)ThreadLocalEventPool.getLocal(MatchError.class)).reqId(request.getReqId()).tenantId(request.getTenantId()).topicFilter(request.getMatcher().getMqttTopicFilter()).receiverId(request.getReceiverId()).subBrokerId(request.getBrokerId()).delivererKey(request.getDelivererKey()).reason(v.getResult().name()));
                    break;
                }
                default: {
                    this.eventCollector.report((Event)((MatchError)ThreadLocalEventPool.getLocal(MatchError.class)).reqId(request.getReqId()).tenantId(request.getTenantId()).topicFilter(request.getMatcher().getMqttTopicFilter()).receiverId(request.getReceiverId()).subBrokerId(request.getBrokerId()).delivererKey(request.getDelivererKey()).reason("Internal Error"));
                }
            }
            return v;
        }));
    }

    @Override
    public void close() {
        this.matchCallScheduler.close();
    }
}

