/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.Iterables;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.bifromq.basecrdt.proto.Dot;
import org.apache.bifromq.basecrdt.proto.Replacement;
import org.apache.bifromq.basecrdt.proto.SingleDot;
import org.apache.bifromq.basecrdt.proto.SingleMap;
import org.apache.bifromq.basecrdt.proto.SingleValue;
import org.apache.bifromq.basecrdt.proto.StateLattice;

class ProtoUtils {
    ProtoUtils() {
    }

    static ByteString toByteString(long l) {
        return UnsafeByteOperations.unsafeWrap((byte[])ByteBuffer.allocate(8).putLong(l).array());
    }

    static Dot dot(ByteString replicaId, long ver) {
        return Dot.newBuilder().setReplicaId(replicaId).setVer(ver).build();
    }

    static Dot dot(ByteString replicaId, long ver, StateLattice lattice) {
        return Dot.newBuilder().setReplicaId(replicaId).setVer(ver).setLattice(lattice).build();
    }

    static Replacement replacement(Dot ... dots) {
        Replacement.Builder builder = Replacement.newBuilder();
        for (Dot dot : dots) {
            builder.addDots(dot);
        }
        return builder.build();
    }

    static Iterable<Replacement> replacements(Dot dot, Iterable<Dot> replacingDots) {
        return replacingDots.iterator().hasNext() ? Iterables.transform(replacingDots, replacingDot -> ProtoUtils.replacement(dot, replacingDot)) : Collections.singleton(ProtoUtils.replacement(dot));
    }

    static StateLattice singleDot(ByteString replicaId, long ver) {
        return StateLattice.newBuilder().setSingleDot(SingleDot.newBuilder().setReplicaId(replicaId).setVer(ver).build()).build();
    }

    static StateLattice singleValue(ByteString replicaId, long ver, ByteString val) {
        return StateLattice.newBuilder().setSingleValue(SingleValue.newBuilder().setReplicaId(replicaId).setVer(ver).setValue(val).build()).build();
    }

    static StateLattice singleMap(ByteString key, StateLattice val) {
        return StateLattice.newBuilder().setSingleMap(SingleMap.newBuilder().setKey(key).setVal(val).build()).build();
    }
}

