/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.loadbalancer;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bifromq.baserpc.client.loadbalancer.HRWRouter;
import org.apache.bifromq.baserpc.client.loadbalancer.IServerGroupRouter;
import org.apache.bifromq.baserpc.client.loadbalancer.LBUtils;
import org.apache.bifromq.baserpc.client.loadbalancer.WCHRouter;

class WeightedServerGroupRouter
implements IServerGroupRouter {
    private final SortedMap<String, Integer> weightedServers;
    private final List<String> weightedServerRRSequence;
    private final HRWRouter<String> hrwRouter;
    private final WCHRouter<String> chRouter;
    private final AtomicInteger rrIndex = new AtomicInteger(0);
    private final Set<String> inProcServers = new HashSet<String>();

    WeightedServerGroupRouter(Map<String, Boolean> allServers, Map<String, Integer> groupWeights, Map<String, Set<String>> serverGroups) {
        this.weightedServers = Maps.newTreeMap();
        for (String group : groupWeights.keySet()) {
            int weight = Math.abs(groupWeights.get(group)) % 11;
            serverGroups.getOrDefault(group, Collections.emptySet()).forEach(serverId -> this.weightedServers.compute((String)serverId, (k, w) -> {
                if (w == null) {
                    w = 0;
                }
                w = Math.max(w, weight);
                return w;
            }));
        }
        this.weightedServerRRSequence = LBUtils.toWeightedRRSequence(this.weightedServers);
        this.chRouter = new WCHRouter<String>(this.weightedServers.keySet(), serverId -> serverId, this.weightedServers::get, 100);
        this.hrwRouter = new HRWRouter<String>(this.weightedServers.keySet(), serverId -> serverId, this.weightedServers::get);
        for (String serverId2 : this.weightedServers.keySet()) {
            if (!allServers.getOrDefault(serverId2, false).booleanValue()) continue;
            this.inProcServers.add(serverId2);
        }
    }

    @Override
    public boolean isSameGroup(IServerGroupRouter other) {
        if (other instanceof WeightedServerGroupRouter) {
            WeightedServerGroupRouter otherRouter = (WeightedServerGroupRouter)other;
            return this.weightedServers.equals(otherRouter.weightedServers);
        }
        return false;
    }

    @Override
    public Optional<String> random() {
        if (this.weightedServerRRSequence.isEmpty()) {
            return Optional.empty();
        }
        if (!this.inProcServers.isEmpty()) {
            return this.inProcServers.stream().findFirst();
        }
        return Optional.of(this.weightedServerRRSequence.get(ThreadLocalRandom.current().nextInt(0, this.weightedServerRRSequence.size())));
    }

    @Override
    public Optional<String> roundRobin() {
        int size = this.weightedServerRRSequence.size();
        if (size == 0) {
            return Optional.empty();
        }
        if (!this.inProcServers.isEmpty()) {
            return this.inProcServers.stream().findFirst();
        }
        int i = this.rrIndex.getAndIncrement();
        if (i >= size) {
            int oldi = i;
            this.rrIndex.compareAndSet(oldi, i %= size);
        }
        return Optional.of(this.weightedServerRRSequence.get(i));
    }

    @Override
    public Optional<String> tryRoundRobin() {
        int size = this.weightedServerRRSequence.size();
        if (size == 0) {
            return Optional.empty();
        }
        if (!this.inProcServers.isEmpty()) {
            return this.inProcServers.stream().findFirst();
        }
        int i = this.rrIndex.get() + 1;
        if (i >= size) {
            i %= size;
        }
        return Optional.of(this.weightedServerRRSequence.get(i));
    }

    @Override
    public Optional<String> hashing(String key) {
        return Optional.ofNullable(this.chRouter.routeNode(key));
    }

    @Override
    public Optional<String> stickyHashing(String key) {
        if (!this.inProcServers.isEmpty()) {
            return this.inProcServers.stream().findFirst();
        }
        return Optional.ofNullable(this.hrwRouter.routeNode(key));
    }
}

