/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.settingprovider;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.plugin.settingprovider.CacheOptions;
import org.apache.bifromq.plugin.settingprovider.CacheableSettingProvider;
import org.apache.bifromq.plugin.settingprovider.DevOnlySettingProvider;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.MonitoredSettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingProviderManager
implements ISettingProvider,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SettingProviderManager.class);
    private static final Logger pluginLog = LoggerFactory.getLogger((String)"plugin.manager");
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final ISettingProvider provider;

    public SettingProviderManager(String settingProviderFQN, PluginManager pluginMgr) {
        Map<String, ISettingProvider> availSettingProviders = pluginMgr.getExtensions(ISettingProvider.class).stream().collect(Collectors.toMap(e -> e.getClass().getName(), e -> e));
        if (availSettingProviders.isEmpty()) {
            pluginLog.warn("No setting provider plugin available, use DEV ONLY one instead");
            this.provider = new MonitoredSettingProvider(new DevOnlySettingProvider());
        } else if (settingProviderFQN == null) {
            pluginLog.warn("Setting provider plugin type not specified, use DEV ONLY one instead");
            this.provider = new MonitoredSettingProvider(new DevOnlySettingProvider());
        } else if (!availSettingProviders.containsKey(settingProviderFQN)) {
            pluginLog.warn("Setting provider plugin type '{}' not found, use DEV ONLY one instead", (Object)settingProviderFQN);
            this.provider = new MonitoredSettingProvider(new DevOnlySettingProvider());
        } else {
            pluginLog.info("Setting provider plugin type: {}", (Object)settingProviderFQN);
            this.provider = new CacheableSettingProvider(new MonitoredSettingProvider(availSettingProviders.get(settingProviderFQN)), CacheOptions.DEFAULT);
        }
        for (Setting setting : Setting.values()) {
            setting.setProvider(this.provider);
        }
    }

    public <R> R provide(Setting setting, String tenantId) {
        assert (!this.stopped.get());
        return (R)this.provider.provide(setting, tenantId);
    }

    @Override
    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            log.debug("Closing setting provider manager");
            this.provider.close();
            log.debug("Setting provider manager closed");
        }
    }
}

