/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.Optional;
import org.apache.bifromq.basekv.localengine.IKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.AbstractRocksDBKVSpaceReader;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.rocksdb.IteratorOptions;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceCheckpoint;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBSnapshot;
import org.apache.bifromq.basekv.proto.Boundary;
import org.slf4j.Logger;

class RocksDBKVSpaceCheckpointReader
extends AbstractRocksDBKVSpaceReader {
    private final IRocksDBKVSpaceEpoch checkpoint;
    private final Map<ByteString, ByteString> metadata;
    private RocksDBKVSpaceCheckpoint strongRef;

    RocksDBKVSpaceCheckpointReader(String id, KVSpaceOpMeters opMeters, Logger logger, RocksDBKVSpaceCheckpoint strongRef, IRocksDBKVSpaceEpoch checkpoint, Map<ByteString, ByteString> metadata) {
        super(id, opMeters, logger);
        this.strongRef = strongRef;
        this.checkpoint = checkpoint;
        this.metadata = metadata;
    }

    @Override
    protected IRocksDBKVSpaceEpoch handle() {
        return this.checkpoint;
    }

    @Override
    protected RocksDBSnapshot snapshot() {
        return new RocksDBSnapshot(this.handle(), null);
    }

    protected Optional<ByteString> doMetadata(ByteString metaKey) {
        return Optional.ofNullable(this.metadata.get(metaKey));
    }

    protected IKVSpaceIterator doNewIterator(Boundary subBoundary) {
        return new RocksDBKVSpaceIterator(this.snapshot(), subBoundary, new IteratorOptions(false, 52428L));
    }

    public void close() {
        this.strongRef = null;
    }
}

