/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.server.scheduler;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.client.exception.BadRequestException;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.InternalErrorException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.store.proto.KVRangeRORequest;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.apache.bifromq.retain.rpc.proto.BatchMatchReply;
import org.apache.bifromq.retain.rpc.proto.BatchMatchRequest;
import org.apache.bifromq.retain.rpc.proto.MatchParam;
import org.apache.bifromq.retain.rpc.proto.MatchReply;
import org.apache.bifromq.retain.rpc.proto.MatchResult;
import org.apache.bifromq.retain.rpc.proto.MatchResultPack;
import org.apache.bifromq.retain.rpc.proto.RetainServiceROCoProcInput;
import org.apache.bifromq.retain.server.scheduler.BatchMatchCallHelper;
import org.apache.bifromq.retain.server.scheduler.MatchCallBatcherKey;
import org.apache.bifromq.retain.server.scheduler.MatchCallRangeRouter;
import org.apache.bifromq.retain.server.scheduler.MatchRetainedRequest;
import org.apache.bifromq.retain.server.scheduler.MatchRetainedResult;
import org.apache.bifromq.util.TopicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchMatchCall
implements IBatchCall<MatchRetainedRequest, MatchRetainedResult, MatchCallBatcherKey> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchMatchCall.class);
    private final MatchCallBatcherKey batcherKey;
    private final IBaseKVStoreClient retainStoreClient;
    private final ISettingProvider settingProvider;
    private Queue<ICallTask<MatchRetainedRequest, MatchRetainedResult, MatchCallBatcherKey>> tasks = new ArrayDeque<ICallTask<MatchRetainedRequest, MatchRetainedResult, MatchCallBatcherKey>>(128);
    private Set<String> nonWildcardTopicFilters = new HashSet<String>(128);
    private Set<String> wildcardTopicFilters = new HashSet<String>(128);

    BatchMatchCall(MatchCallBatcherKey batcherKey, IBaseKVStoreClient retainStoreClient, ISettingProvider settingProvider) {
        this.batcherKey = batcherKey;
        this.retainStoreClient = retainStoreClient;
        this.settingProvider = settingProvider;
    }

    public void add(ICallTask<MatchRetainedRequest, MatchRetainedResult, MatchCallBatcherKey> task) {
        this.tasks.add(task);
        if (TopicUtil.isWildcardTopicFilter((String)((MatchRetainedRequest)task.call()).topicFilter())) {
            this.wildcardTopicFilters.add(((MatchRetainedRequest)task.call()).topicFilter());
        } else {
            this.nonWildcardTopicFilters.add(((MatchRetainedRequest)task.call()).topicFilter());
        }
    }

    public void reset(boolean abort) {
        if (abort) {
            this.tasks = new ArrayDeque<ICallTask<MatchRetainedRequest, MatchRetainedResult, MatchCallBatcherKey>>(128);
            this.nonWildcardTopicFilters = new HashSet<String>(128);
            this.wildcardTopicFilters = new HashSet<String>(128);
        } else {
            this.nonWildcardTopicFilters.clear();
            this.wildcardTopicFilters.clear();
        }
    }

    public CompletableFuture<Void> execute() {
        return this.execute(this.tasks, this.nonWildcardTopicFilters, this.wildcardTopicFilters);
    }

    private CompletableFuture<Void> execute(Queue<ICallTask<MatchRetainedRequest, MatchRetainedResult, MatchCallBatcherKey>> tasks, Set<String> nonWildcardTopicFilters, Set<String> wildcardTopicFilters) {
        CompletableFuture<Map<Object, Object>> wildcardMatchFuture;
        long now = HLC.INST.getPhysical();
        long reqId = System.nanoTime();
        NavigableMap effectiveRouter = this.retainStoreClient.latestEffectiveRouter();
        Map<KVRangeSetting, Set<String>> parallelMatches = MatchCallRangeRouter.rangeLookup(this.batcherKey.tenantId(), nonWildcardTopicFilters, effectiveRouter);
        CompletableFuture<Map<String, MatchResult>> parallelMatchFutures = BatchMatchCallHelper.parallelMatch(reqId, now, parallelMatches, this::match);
        if (wildcardTopicFilters.isEmpty()) {
            wildcardMatchFuture = CompletableFuture.completedFuture(Collections.emptyMap());
        } else {
            int limit = (Integer)this.settingProvider.provide(Setting.RetainMessageMatchLimit, this.batcherKey.tenantId());
            Map<KVRangeSetting, Set<String>> serialMatches = MatchCallRangeRouter.rangeLookup(this.batcherKey.tenantId(), wildcardTopicFilters, effectiveRouter);
            wildcardMatchFuture = BatchMatchCallHelper.serialMatch(reqId, now, serialMatches, limit, this::match);
        }
        return CompletableFuture.allOf(parallelMatchFutures, wildcardMatchFuture).handle(CompletableFutureUtil.unwrap((v, e) -> {
            if (e != null) {
                ICallTask task;
                if (e instanceof ServerNotFoundException || e instanceof TryLaterException || e instanceof BadVersionException) {
                    ICallTask task2;
                    while ((task2 = (ICallTask)tasks.poll()) != null) {
                        task2.resultPromise().complete(new MatchRetainedResult(MatchReply.Result.TRY_LATER, Collections.emptyList()));
                    }
                    return null;
                }
                while ((task = (ICallTask)tasks.poll()) != null) {
                    task.resultPromise().complete(new MatchRetainedResult(MatchReply.Result.ERROR, Collections.emptyList()));
                }
            } else {
                ICallTask task;
                HashMap aggregatedResults = new HashMap();
                aggregatedResults.putAll((Map)parallelMatchFutures.join());
                aggregatedResults.putAll((Map)wildcardMatchFuture.join());
                while ((task = (ICallTask)tasks.poll()) != null) {
                    MatchResult matchResult = (MatchResult)aggregatedResults.get(((MatchRetainedRequest)task.call()).topicFilter());
                    task.resultPromise().complete(new MatchRetainedResult(MatchReply.Result.OK, matchResult.getMessagesList()));
                }
            }
            return null;
        }));
    }

    private CompletableFuture<Map<String, MatchResult>> match(long reqId, long now, Map<String, Integer> topicFilters, KVRangeSetting rangeSetting) {
        BatchMatchRequest request = BatchMatchRequest.newBuilder().putMatchParams(this.batcherKey.tenantId(), MatchParam.newBuilder().putAllTopicFilters(topicFilters).setNow(now).build()).setReqId(reqId).build();
        return this.queryCoProc(request, rangeSetting).thenApply(reply -> ((MatchResultPack)reply.getResultPackMap().get(this.batcherKey.tenantId())).getResultsMap());
    }

    private CompletableFuture<BatchMatchReply> queryCoProc(BatchMatchRequest request, KVRangeSetting rangeSetting) {
        Optional replica = rangeSetting.randomReplicaForQuery();
        if (replica.isEmpty()) {
            return CompletableFuture.failedFuture((Throwable)new TryLaterException());
        }
        return this.retainStoreClient.query((String)replica.get(), KVRangeRORequest.newBuilder().setReqId(request.getReqId()).setKvRangeId(rangeSetting.id()).setVer(rangeSetting.ver()).setRoCoProc(ROCoProcInput.newBuilder().setRetainService(RetainServiceROCoProcInput.newBuilder().setBatchMatch(request).build()).build()).build()).thenApply(v -> {
            switch (v.getCode()) {
                case Ok: {
                    return v.getRoCoProcResult().getRetainService().getBatchMatch();
                }
                case TryLater: {
                    throw new TryLaterException();
                }
                case BadVersion: {
                    throw new BadVersionException();
                }
                case BadRequest: {
                    throw new BadRequestException();
                }
            }
            throw new InternalErrorException();
        });
    }
}

