/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.bifromq.basecrdt.core.api.AWORSetOperation;
import org.apache.bifromq.basecrdt.core.internal.CoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.DotSet;
import org.apache.bifromq.basecrdt.core.internal.ICoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.IDotMap;
import org.apache.bifromq.basecrdt.core.internal.ProtoUtils;
import org.apache.bifromq.basecrdt.proto.Replacement;

class AWORSetCoalesceOperation
extends CoalesceOperation<IDotMap, AWORSetOperation> {
    private boolean clearAtFirst = false;
    private final Set<ByteString> adds = Sets.newConcurrentHashSet();
    private final Set<ByteString> rems = Sets.newConcurrentHashSet();

    AWORSetCoalesceOperation(ByteString replicaId, AWORSetOperation op) {
        super(replicaId);
        this.coalesce(op);
    }

    @Override
    public void coalesce(AWORSetOperation op) {
        if (op.type == AWORSetOperation.Type.Clear) {
            this.clearAtFirst = true;
            this.adds.clear();
            this.rems.clear();
        } else {
            switch (op.type) {
                case Add: {
                    this.adds.add(op.element);
                    this.rems.remove(op.element);
                    break;
                }
                case Remove: {
                    this.adds.remove(op.element);
                    this.rems.add(op.element);
                }
            }
        }
    }

    @Override
    public Iterable<Replacement> delta(IDotMap current, ICoalesceOperation.IEventGenerator eventGenerator) {
        Iterable addDots = this.adds.stream().map(e -> {
            long ver = eventGenerator.nextEvent();
            return ProtoUtils.replacement(ProtoUtils.dot(this.replicaId, ver, ProtoUtils.singleMap(e, ProtoUtils.singleDot(this.replicaId, ver))));
        }).collect(Collectors.toSet());
        if (this.clearAtFirst && !current.isBottom()) {
            return Iterables.concat((Iterable)addDots, ProtoUtils.replacements(ProtoUtils.dot(this.replicaId, eventGenerator.nextEvent()), current));
        }
        return Iterables.concat((Iterable)addDots, (Iterable)Iterables.transform((Iterable)Iterables.concat((Iterable)this.rems.stream().map(e -> current.subDotSet((ByteString)e).orElse(DotSet.BOTTOM)).collect(Collectors.toSet())), xva$0 -> ProtoUtils.replacement(xva$0)));
    }
}

