/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.wal;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.bifromq.base.util.AsyncRunner;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeSnapshot;
import org.apache.bifromq.basekv.raft.event.CommitEvent;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.store.wal.IKVRangeWAL;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALSubscriber;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALSubscription;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class KVRangeWALSubscription
implements IKVRangeWALSubscription {
    private final Logger log;
    private final long maxFetchBytes;
    private final IKVRangeWAL wal;
    private final Executor executor;
    private final AsyncRunner fetchRunner;
    private final AsyncRunner applyRunner;
    private final IKVRangeWALSubscriber subscriber;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final AtomicBoolean fetching = new AtomicBoolean();
    private final AtomicBoolean restoring = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final CompletableFuture<Void> stopSign = new CompletableFuture();
    private final AtomicLong lastFetchedIdx = new AtomicLong();
    private final ConcurrentSkipListMap<Long, Boolean> pendingApplies = new ConcurrentSkipListMap();

    KVRangeWALSubscription(long maxFetchBytes, IKVRangeWAL wal, Observable<CommitEvent> commitIndex, long lastFetchedIndex, IKVRangeWALSubscriber subscriber, Executor executor, String ... tags) {
        this.log = MDCLogger.getLogger(KVRangeWALSubscription.class, (String[])tags);
        this.maxFetchBytes = maxFetchBytes;
        this.wal = wal;
        this.executor = executor;
        this.fetchRunner = new AsyncRunner("basekv.runner.walfetch", executor, new String[]{"rangeId", KVRangeIdUtil.toString((KVRangeId)wal.rangeId())});
        this.applyRunner = new AsyncRunner("basekv.runner.fsmapply", executor, new String[]{"rangeId", KVRangeIdUtil.toString((KVRangeId)wal.rangeId())});
        this.subscriber = subscriber;
        this.lastFetchedIdx.set(lastFetchedIndex);
        this.subscriber.onSubscribe(this);
        this.disposables.add(wal.snapshotRestoreTask().subscribe(task -> {
            this.applyRunner.cancelAll();
            this.fetchRunner.cancelAll();
            this.fetching.set(false);
            this.restoring.set(true);
            this.fetchRunner.add(() -> {
                this.applyRunner.cancelAll();
                return this.applyRunner.add(this.restore((IKVRangeWAL.RestoreSnapshotTask)task));
            }).handle((snap, e) -> this.fetchRunner.add(() -> {
                if (e != null) {
                    this.log.error("Failed to restore from snapshot\n{}", (Object)task.snapshot, e);
                    return;
                }
                this.log.debug("Snapshot installed\n{}", snap);
                this.lastFetchedIdx.set(snap.getLastAppliedIndex());
                this.pendingApplies.clear();
                this.restoring.set(false);
                this.scheduleFetchWAL();
            }));
        }));
        this.disposables.add(commitIndex.subscribe(c -> this.fetchRunner.add(() -> {
            if (this.restoring.get()) {
                return;
            }
            Map.Entry<Long, Boolean> prevCommitIdx = this.pendingApplies.floorEntry(c.index);
            if (prevCommitIdx != null && prevCommitIdx.getValue() == c.isLeader) {
                this.pendingApplies.remove(prevCommitIdx.getKey());
            }
            this.pendingApplies.put(c.index, c.isLeader);
            this.scheduleFetchWAL();
        })));
    }

    @Override
    public CompletionStage<Void> stop() {
        if (this.stopped.compareAndSet(false, true)) {
            this.disposables.dispose();
            this.fetchRunner.cancelAll();
            this.applyRunner.cancelAll();
            ((CompletableFuture)CompletableFuture.allOf(this.fetchRunner.awaitDone().toCompletableFuture(), this.applyRunner.awaitDone().toCompletableFuture()).exceptionally(e -> {
                this.log.error("WAL Subscripiton stop error", e);
                return null;
            })).whenComplete((v, e) -> this.stopSign.complete(null));
        }
        return this.stopSign;
    }

    private void scheduleFetchWAL() {
        if (!this.stopped.get() && this.fetching.compareAndSet(false, true)) {
            this.fetchRunner.add(this::fetchWAL);
        }
    }

    private CompletableFuture<Void> fetchWAL() {
        if (this.restoring.get()) {
            this.fetching.set(false);
            return CompletableFuture.completedFuture(null);
        }
        NavigableMap<Long, Boolean> toFetch = this.shouldFetch();
        if (!toFetch.isEmpty()) {
            return this.wal.retrieveCommitted(this.lastFetchedIdx.get() + 1L, this.maxFetchBytes).handleAsync((logEntries, e) -> {
                if (e != null) {
                    this.log.error("Failed to retrieve log from wal from index[{}]", (Object)(this.lastFetchedIdx.get() + 1L), e);
                    this.fetching.set(false);
                    if (!(e instanceof IndexOutOfBoundsException)) {
                        this.scheduleFetchWAL();
                    }
                } else {
                    this.fetchRunner.add(() -> {
                        LogEntry entry = null;
                        boolean hasMore = false;
                        while (logEntries.hasNext()) {
                            entry = (LogEntry)logEntries.next();
                            Map.Entry commitIdx = toFetch.ceilingEntry(entry.getIndex());
                            if (commitIdx != null) {
                                boolean isLeader = (Boolean)commitIdx.getValue();
                                this.applyRunner.add(this.applyLog(entry, isLeader));
                                continue;
                            }
                            hasMore = true;
                            break;
                        }
                        logEntries.close();
                        if (entry != null) {
                            if (hasMore) {
                                this.lastFetchedIdx.set(Math.max(entry.getIndex() - 1L, this.lastFetchedIdx.get()));
                            } else {
                                this.lastFetchedIdx.set(Math.max(entry.getIndex(), this.lastFetchedIdx.get()));
                            }
                        }
                        this.fetching.set(false);
                        if (!this.shouldFetch().isEmpty()) {
                            this.scheduleFetchWAL();
                        }
                    });
                }
                return null;
            }, this.executor);
        }
        this.fetching.set(false);
        if (!this.shouldFetch().isEmpty()) {
            this.scheduleFetchWAL();
        }
        return CompletableFuture.completedFuture(null);
    }

    private NavigableMap<Long, Boolean> shouldFetch() {
        this.pendingApplies.headMap((Object)this.lastFetchedIdx.get(), true).clear();
        return this.pendingApplies.tailMap((Object)(this.lastFetchedIdx.get() + 1L));
    }

    private Supplier<CompletableFuture<Void>> applyLog(LogEntry logEntry, boolean isLeader) {
        return () -> {
            CompletableFuture onDone = new CompletableFuture();
            CompletableFuture<Void> applyFuture = this.subscriber.apply(logEntry, isLeader);
            onDone.whenComplete((v, e) -> {
                if (onDone.isCancelled()) {
                    applyFuture.cancel(true);
                }
            });
            applyFuture.whenCompleteAsync((v, e) -> this.fetchRunner.add(() -> {
                if (!onDone.isCancelled() && e != null) {
                    this.applyRunner.addFirst(this.applyLog(logEntry, isLeader));
                }
                onDone.complete(null);
            }), this.executor);
            return onDone;
        };
    }

    private Supplier<CompletableFuture<KVRangeSnapshot>> restore(IKVRangeWAL.RestoreSnapshotTask task) {
        return () -> {
            CompletableFuture onDone = new CompletableFuture();
            CompletableFuture<Void> restoreTask = this.subscriber.restore(task.snapshot, task.leader, (installed, ex) -> task.afterRestored(installed, ex).whenComplete((v, e) -> {
                if (e != null) {
                    onDone.completeExceptionally((Throwable)e);
                } else {
                    onDone.complete(installed);
                }
            }));
            onDone.whenComplete((v, e) -> {
                if (onDone.isCancelled()) {
                    restoreTask.cancel(true);
                }
            });
            return onDone;
        };
    }
}

