/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.gravitino.listener.api.EventListenerPlugin;
import org.apache.gravitino.listener.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerPluginWrapper
implements EventListenerPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(EventListenerPluginWrapper.class);
    private String listenerName;
    private EventListenerPlugin userEventListener;

    public EventListenerPluginWrapper(String listenerName, EventListenerPlugin userEventListener) {
        this.listenerName = listenerName;
        this.userEventListener = userEventListener;
    }

    @Override
    public void init(Map<String, String> properties) {
        throw new RuntimeException("Should not reach here, the event listener has already been initialized.");
    }

    @Override
    public void start() {
        this.userEventListener.start();
        LOG.info("Start event listener {}.", (Object)this.listenerName);
    }

    @Override
    public void stop() {
        try {
            this.userEventListener.stop();
            LOG.info("Stop event listener {}.", (Object)this.listenerName);
        }
        catch (Exception e) {
            LOG.warn("Failed to stop event listener {}.", (Object)this.listenerName, (Object)e);
        }
    }

    @Override
    public void onPostEvent(Event event) {
        try {
            this.userEventListener.onPostEvent(event);
        }
        catch (Exception e) {
            LOG.warn("Event listener {} process event {} failed,", new Object[]{this.listenerName, event.getClass().getSimpleName(), e});
        }
    }

    @VisibleForTesting
    EventListenerPlugin getUserEventListener() {
        return this.userEventListener;
    }
}

