/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogProvider;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class CatalogCreateRequest
implements RESTRequest {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final Catalog.Type type;
    @JsonProperty(value="provider")
    private String provider;
    @Nullable
    @JsonProperty(value="comment")
    private final String comment;
    @Nullable
    @JsonProperty(value="properties")
    private final Map<String, String> properties;

    @JsonCreator
    public CatalogCreateRequest(@JsonProperty(value="name") String name, @JsonProperty(value="type") Catalog.Type type, @JsonProperty(value="provider") String provider, @JsonProperty(value="comment") String comment, @JsonProperty(value="properties") Map<String, String> properties) {
        this.name = name;
        this.type = type;
        this.comment = comment;
        this.properties = properties;
        if (StringUtils.isNotBlank(provider)) {
            this.provider = provider;
        } else if (type != null && type.supportsManagedCatalog()) {
            this.provider = CatalogProvider.shortNameForManagedCatalog(type);
        } else {
            throw new IllegalArgumentException("Provider cannot be null for catalog type " + (Object)((Object)type) + " that doesn't support managed catalog");
        }
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "\"name\" field is required and cannot be empty");
        Preconditions.checkArgument(this.type != null, "\"type\" field is required and cannot be empty");
        Preconditions.checkArgument(StringUtils.isNotBlank(this.provider) || this.type.supportsManagedCatalog(), "\"provider\" field is required and cannot be empty for catalog type " + (Object)((Object)this.type) + " that doesn't support managed catalog");
    }

    public String getName() {
        return this.name;
    }

    public Catalog.Type getType() {
        return this.type;
    }

    public String getProvider() {
        return this.provider;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatalogCreateRequest)) {
            return false;
        }
        CatalogCreateRequest other = (CatalogCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Catalog.Type this$type = this.getType();
        Catalog.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CatalogCreateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Catalog.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "CatalogCreateRequest(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", provider=" + this.getProvider() + ", comment=" + this.getComment() + ", properties=" + this.getProperties() + ")";
    }
}

