/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.guava.hash;

import io.trino.jdbc.$internal.guava.annotations.Beta;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.hash.ElementTypesAreNonnullByDefault;
import io.trino.jdbc.$internal.guava.hash.HashCode;
import io.trino.jdbc.$internal.guava.hash.HashFunction;
import io.trino.jdbc.$internal.guava.hash.Hasher;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@ElementTypesAreNonnullByDefault
@Beta
public final class HashingOutputStream
extends FilterOutputStream {
    private final Hasher hasher;

    public HashingOutputStream(HashFunction hashFunction, OutputStream out) {
        super(Preconditions.checkNotNull(out));
        this.hasher = Preconditions.checkNotNull(hashFunction.newHasher());
    }

    @Override
    public void write(int b) throws IOException {
        this.hasher.putByte((byte)b);
        this.out.write(b);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.hasher.putBytes(bytes, off, len);
        this.out.write(bytes, off, len);
    }

    public HashCode hash() {
        return this.hasher.hash();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

